#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#include <string>

HWND hButton, hText, hTextBox;
enum BUTTON_IDS { ID_IMPORT = 1 };
 
HINSTANCE FindInstance(const char* windowClassName)
{
    HWND hwndApp = FindWindowA(NULL, windowClassName);
	return (HINSTANCE)GetWindowLong(hwndApp, GWL_HINSTANCE);
}
 
HWND ButtonFactory(const char* Caption, const char* windowClassName, HWND hWnd, BUTTON_IDS button_id, int X, int Y, int width, int height, DWORD uStyle, DWORD uExStyle)
{
	
    HINSTANCE hInstance = FindInstance("simpleWindow");
 
    return CreateWindowEx(
        uExStyle,
        Caption,
        windowClassName,
        uStyle,
        X, Y,
        width, height,
        hWnd,
        (HMENU)button_id,
        hInstance,
        NULL
    );
}
 
LRESULT CALLBACK WndProcEvent(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
 
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmd, int nShowCmd)
{
    WNDCLASSEX classWindow;
    ZeroMemory(&classWindow, sizeof(classWindow));
    classWindow.cbSize = sizeof(classWindow);
    classWindow.hInstance = hInstance;
    classWindow.lpfnWndProc = WndProcEvent;
    classWindow.hbrBackground = (HBRUSH) COLOR_WINDOW;
    classWindow.hCursor = LoadCursor(hInstance, IDC_ARROW);
    classWindow.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	classWindow.hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
    classWindow.lpszClassName = "importDyn";
 
    RegisterClassEx(&classWindow);
 
    HWND hWnd = CreateWindowEx(
        NULL,
        "importDyn",
        "Importowanie Dynamiczne",
		WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        420,
        190,
        (HWND)NULL,
        (HMENU)NULL,
        hInstance,
        NULL
        );
 
    ShowWindow(hWnd, nShowCmd);
 
    MSG msgMsg;
    while(GetMessage(&msgMsg, NULL, 0, 0))
    {
        TranslateMessage(&msgMsg);
        DispatchMessage(&msgMsg);
    }
 
    return static_cast<int>(msgMsg.wParam);
}
 
LRESULT CALLBACK WndProcEvent(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uMsg)
    {
    case WM_CREATE:
		hText = ButtonFactory("static", "Plik biblioteki DLL:", hWnd, (BUTTON_IDS)NULL, 30, 20, 350, 20, WS_CHILD | WS_VISIBLE, WS_EX_TRANSPARENT);
		hTextBox = ButtonFactory("edit", "MessagesDLL.dll", hWnd, (BUTTON_IDS)NULL, 30, 40, 350, 20, WS_CHILD | WS_VISIBLE | WS_BORDER, NULL);
        hButton = ButtonFactory("Button", "Zaaduj bibliotek do pamici i uruchom funkcje", hWnd, ID_IMPORT, 30, 80, 350, 60, WS_CHILD | WS_VISIBLE, NULL);
        break;
    case WM_COMMAND:
        switch(wParam)
        {
        case ID_IMPORT:
			char* Plik = new char[1024];
			GetWindowText(hTextBox, Plik, 1024);
			HINSTANCE hDll = LoadLibrary(Plik);
			if(hDll != NULL)
			{
				char* temp = new char[1024];
				sprintf_s(temp, sizeof(char)*1024, "Wczytanie biblioteki powiodo si! Uchwyt: %d", (int)hDll);
				MessageBox(NULL, temp, "Informacja", MB_OK);
				delete temp;
			}
			else
			{
				MessageBox(NULL, "Wczytanie biblioteki nie powiodo si!", "Bd", MB_OK | MB_ICONERROR);
				return -1;
			}

			typedef void (*DllTestType)();

			DllTestType Test0 = (DllTestType)GetProcAddress(hDll,"Test0");
			if(Test0 == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test0 nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
				Test0();

			DllTestType Test1 = (DllTestType)GetProcAddress(hDll,"Test1");
			if(Test0 == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test1 nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
				Test1();

			DllTestType Test2 = (DllTestType)GetProcAddress(hDll, "_Test2@0");
			if(Test2 == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test2 nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
				Test2();

			typedef int (__stdcall *DllTest3aType)(const char* Text);

			DllTest3aType  Test3a = (DllTest3aType)GetProcAddress(hDll,"_Test3a@4");
			if(Test3a == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test3a nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
			{
				int wynik = Test3a("Przykadowy tekst");
				
				char* temp = new char[1024];
				sprintf_s(temp, sizeof(char)*1024, "Wynik: %d", wynik);
				MessageBox(NULL, temp, "Wynik", MB_OK);
				delete temp;
			}
			
			typedef char* (__stdcall *DllTest3bType)(const char* Text);

			DllTest3bType  Test3b = (DllTest3bType)GetProcAddress(hDll,"_Test3b@4");
			if(Test3b == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test3b nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
			{
				char* temp = new char[1024];
				char* temp2 = new char[1024];
				sprintf_s(temp, sizeof(char)*1024, Test3b("Kolejny przykadowy tekst"));
				sprintf_s(temp2, sizeof(char)*1024, "Wynik: %s", temp);
				MessageBox(NULL, temp2, "Wynik", MB_OK);
				delete temp2;
				delete temp;
			}

			typedef int (__stdcall *DllTest3cType)(int i);

			DllTest3cType Test3c = (DllTest3cType)GetProcAddress(hDll, "_Test3c@4");
			if(Test3c == NULL)
				MessageBox(NULL, "Pobranie adresu funkcji Test3c nie byo moliwe!", "Bd", MB_OK | MB_ICONERROR);
			else
			{
				char* temp = new char[1024];
				int wynik = Test3c(32);
				sprintf_s(temp, sizeof(char)*1024, "Wynik: %d", wynik);
				MessageBox(NULL, temp, "Wynik", MB_OK);
				delete temp;
			}

			delete Plik;

			if(FreeLibrary(hDll))
				MessageBox(NULL, "Wyadowanie biblioteki z pamici zakoczone powodzeniem!", "Informacja", MB_OK | MB_ICONASTERISK);
			else
				MessageBox(NULL, "Wyadowanie biblioteki z pamici zakoczone niepowodzeniem!", "Bd", MB_OK | MB_ICONERROR); 
            break;
        }
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    }
 
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}