#include <windows.h>
#include <WindowsX.h>
#include <commctrl.h> 
#include <scrnsave.h> 
#include<string.h>

#include "snieg.h"

#pragma comment (lib, "scrnsavw.lib")
#pragma comment (lib, "comctl32.lib")
#pragma comment (lib, "Msimg32.lib")

string NazwaKlucza ="SOFTWARE\\\\WygaszaczSnieg";
wstring WStr(string nazwa);
void Odczytaj();
void Zapisz();
long iSzerokosc, iWysokosc;
HBRUSH brush;
UINT uTimer;

int gestosc,predkosc;
int tlo;


 HBRUSH BitmapBrush();
 
// Procedura dialogu konfiguracyjnego
BOOL WINAPI ScreenSaverConfigureDialog(HWND dialog,UINT komunikat, WPARAM wParam, LPARAM lParam)
{
	string tmp;
	switch(komunikat)
	{
	case WM_INITDIALOG: 
		Odczytaj();
   // Ustaw zakres paska przesuwnego na 0-20 
   SendDlgItemMessage(dialog, 111, TBM_SETRANGE, TRUE, MAKELONG(1,70)); 
   // Ustaw pozycj suwaka zalenie od prdkoci 
   SendDlgItemMessage(dialog, 111, TBM_SETPOS, (WPARAM)TRUE, gestosc); 
   // Ustaw zakres paska przesuwnego na 5-500 
   SendDlgItemMessage(dialog, 112, TBM_SETRANGE, TRUE, MAKELONG(1,20)); 
   // Ustaw pozycj suwaka zalenie od prdkoci 
   SendDlgItemMessage(dialog, 112, TBM_SETPOS, (WPARAM)TRUE, predkosc);
   if(tlo==0)
	   SendDlgItemMessage(dialog,114,BM_SETCHECK,BST_CHECKED,NULL);
   else if(tlo==1)
	   SendDlgItemMessage(dialog,115,BM_SETCHECK,BST_CHECKED,NULL);
   else
	   SendDlgItemMessage(dialog,113,BM_SETCHECK,BST_CHECKED,NULL);

   return TRUE; 
	case WM_COMMAND: 
		switch(LOWORD(wParam)) 
		{ 
			case IDOK: 
				if(BST_CHECKED==SendDlgItemMessage(dialog,113,BM_GETCHECK,NULL,NULL))
					tlo=2;
				else if(BST_CHECKED==SendDlgItemMessage(dialog,115,BM_GETCHECK,NULL,NULL))
					tlo=1;
				else tlo=0;

				predkosc=SendDlgItemMessage(dialog, 112, TBM_GETPOS, 0, 0);
				
				gestosc=SendDlgItemMessage(dialog, 111, TBM_GETPOS, 0, 0); 
				Zapisz();
				EndDialog(dialog, TRUE); 
				break; 
			case IDCANCEL: 
				EndDialog(dialog, FALSE); 
			return TRUE; 
  
			
   return FALSE; 
   } 
}
       
        return FALSE;
}
 
 
BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
        InitCommonControls();
        return TRUE;
}
 
 
LONG WINAPI ScreenSaverProc(HWND okno, UINT komunikat, WPARAM wParam, LPARAM lParam)
{
        HDC kont;
        switch(komunikat)
        {
                case WM_CREATE:
                        /* Wcz zegar generujcy komunikaty WM_TIMER co okres czasu = prdko*1/20 [sek] */
			        iSzerokosc = GetSystemMetrics(SM_CXSCREEN);
		            iWysokosc = GetSystemMetrics(SM_CYSCREEN);
					Odczytaj();
	                uTimer = SetTimer(okno, 1, predkosc*5, NULL);
					if(tlo==2)
						brush=(HBRUSH)GetStockObject(BLACK_BRUSH);
					else
						brush=BitmapBrush();
					
					SnieznyWygaszacz(2,iWysokosc,iSzerokosc, brush,tlo);
                    break;
                case WM_TIMER:
				    kont = GetDC(okno);
					Run(kont,gestosc,iWysokosc,iSzerokosc);
					ReleaseDC(okno, kont);
					break;
                case WM_DESTROY:
					if (uTimer) KillTimer(okno, uTimer);
					break;
				case WM_ERASEBKGND:
					RECT WindowsRect;
					kont = GetDC(okno);
					GetWindowRect(GetDesktopWindow(),&WindowsRect);
					FillRect(kont,&WindowsRect,brush);
					ReleaseDC(okno, kont);
					return 0;
					break;
        }
        return DefScreenSaverProc(okno, komunikat, wParam, lParam);
}
 
 
// Funkcja odczytuje ustawienia wygaszacza z rejestru

 
// Funkcja rysuje zawarto ekranu

 HBRUSH BitmapBrush()
{
		HDC hDesktopDC,hBitmapdc;
		int nWidth,nHeight;
		HBITMAP horiginal;
		HBITMAP Bitmap;

		hDesktopDC=GetWindowDC(HWND_DESKTOP);
		nWidth=GetSystemMetrics(SM_CXSCREEN);
		nHeight=GetSystemMetrics(SM_CYSCREEN);
		Bitmap=CreateCompatibleBitmap(hDesktopDC,nWidth,nHeight);

		hBitmapdc=CreateCompatibleDC(hDesktopDC);

		horiginal=(HBITMAP)SelectBitmap(hBitmapdc,Bitmap);
		BitBlt(hBitmapdc,0,0,nWidth,nHeight,hDesktopDC,0,0,SRCCOPY);
		DeleteDC(hBitmapdc);
		ReleaseDC(HWND_DESKTOP,hDesktopDC);
		HBRUSH bmpBrush=CreatePatternBrush(Bitmap);
		return bmpBrush;
}



void Zapisz()
{
        HKEY klucz;
        DWORD akcja;
        // Otwrz odpowiedni klucz rejestru
		RegCreateKeyEx( HKEY_CURRENT_USER, WStr(NazwaKlucza).c_str() , 0, NULL,
                REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &klucz, &akcja);
        // Zapisz informacje o prdkoci
		RegSetValueEx(klucz, WStr("Gestosc").c_str(), 0, REG_DWORD, (CONST BYTE *)&gestosc, 4);
        // Zapisz informacje o liczbe punktow
		RegSetValueEx(klucz, WStr("Predkosc").c_str(), 0, REG_DWORD, (CONST BYTE *)&predkosc, 4);
		RegSetValueEx(klucz, WStr("Tlo").c_str(), 0, REG_DWORD, (CONST BYTE *)&tlo, 4);
        // Zamknij otwarty klucz rejestru
        RegCloseKey(klucz);
}


void Odczytaj()
{
        HKEY klucz;
        DWORD rozm = 4;
        // Otwrz odpowiedni klucz rejestru
		if(RegOpenKeyEx( HKEY_CURRENT_USER, WStr(NazwaKlucza).c_str(), 0,
                KEY_QUERY_VALUE, &klucz) == ERROR_SUCCESS)
        {
                // Odczytaj prdko
			RegQueryValueEx(klucz, WStr("Gestosc").c_str(), 0, NULL, (BYTE *)&gestosc, &rozm);
                if(predkosc<0 || predkosc>20) predkosc = 2;
                // Odczytaj liczbe punktow
				RegQueryValueEx(klucz, WStr("Predkosc").c_str(), 0, NULL, (BYTE *)&predkosc, &rozm);
				RegQueryValueEx(klucz,  WStr("Tlo").c_str(), 0, NULL, (BYTE *)&tlo, &rozm);
				//gestosc=gestosc*0.01*iSzerokosc;
                RegCloseKey(klucz);
        }
        else
        {
                // ustawienia domylne, wane przy pierwszym uruchomieniu programu
                tlo=0;
                predkosc = 5;
				gestosc=10;
        }
}

wstring WStr(string nazwa)
{
	int len=nazwa.length()+1;
	wstring nowy(len,L''); 
	copy(nazwa.begin(), nazwa.end(), nowy.begin());
	return nowy;
}

int procent(int liczba)
{
	return liczba*100/iSzerokosc;
}

int liczba(int procent)
{
	return iSzerokosc*procent;
}