//---------------------------------------------------------------------------

#include <windows.h>
#include <commctrl.h>
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------
__declspec(dllexport) HINSTANCE appInst;
__declspec(dllexport) HWND panel;
__declspec(dllexport) HWND trackbar1;
__declspec(dllexport) HWND trackbar2;
__declspec(dllexport) HWND trackbar3;

extern "C" __declspec(dllexport)LRESULT CALLBACK WndProcedure(HWND hWnd, UINT uMsg,
			      WPARAM wParam, LPARAM lParam);

extern "C" __declspec(dllexport)HWND WINAPI CreateTrackbar(
    HWND hwndDlg,
    UINT iMin,
    UINT iMax,
    UINT iSelMin,
    UINT iSelMax, HMENU id);



#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
        return 1;
}
//---------------------------------------------------------------------------


LRESULT CALLBACK WndProcedure(HWND hWnd, UINT Msg,
			   WPARAM wParam, LPARAM lParam)
{
    switch(Msg)
    {
    case WM_CTLCOLORSTATIC:
{
    DWORD dwPos1 = SendMessage(trackbar1, TBM_GETPOS, 0, 0);
    DWORD dwPos2 = SendMessage(trackbar2, TBM_GETPOS, 0, 0);
    DWORD dwPos3 = SendMessage(trackbar3, TBM_GETPOS, 0, 0);
    HWND hCtl =( HWND ) lParam;
    HBRUSH brush=CreateSolidBrush(RGB((int)dwPos1,(int)dwPos2,(int)dwPos3));
    if( hCtl == panel )
    {
        return (LRESULT) brush;
    }
    else
        return (LRESULT)GetStockObject(WHITE_BRUSH) ;
}
    case  WM_HSCROLL:
    {
    RedrawWindow(panel, NULL, NULL,RDW_INVALIDATE);
        break;
        }
    case WM_DESTROY:
        PostQuitMessage(WM_QUIT);
        break;
    default:
        return DefWindowProc(hWnd, Msg, wParam, lParam);
    }
    return 0;
}


HWND WINAPI CreateTrackbar(
    HWND hwndDlg,
    UINT iMin,
    UINT iMax,
    UINT iSelMin,
    UINT iSelMax,
    HMENU id)
{

    InitCommonControls();
    HWND hwndTrack = CreateWindowEx(
        0,
        TRACKBAR_CLASS,
        "Trackbar Control",
        WS_CHILD | WS_VISIBLE | TBS_ENABLESELRANGE | TBS_AUTOTICKS,
        10, 120 + (int)id*40,
        215, 30,
        hwndDlg,
        id,
        appInst,
        NULL
        );
    //ustawiamy min i max trackabara
    SendMessage(hwndTrack, TBM_SETRANGE,
        (WPARAM) TRUE,
        (LPARAM) MAKELONG(iMin, iMax));

    SendMessage(hwndTrack, TBM_SETPAGESIZE,
        0, (LPARAM) 4);

    SendMessage(hwndTrack, TBM_SETTICFREQ,
        15, (LPARAM) 1);

    SendMessage(hwndTrack, TBM_SETSEL,
        (WPARAM) FALSE,
        (LPARAM) MAKELONG(iSelMin, iSelMax));

    SendMessage(hwndTrack, TBM_SETPOS,
        (WPARAM) TRUE,
        (LPARAM) iSelMin);

    SetFocus(hwndTrack);

    return hwndTrack;
}