//---------------------------------------------------------------------------


#include <vcl.h>
#pragma hdrstop


#include "Unit1.h"
#include "Unit2.h"
#include <windows.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
    ComboBox1->ItemIndex=1;
}
//---------------------------------------------------------------------------

 bool GetNameFromSid(PSID pSid,TCHAR **buffer)
{
        if(*buffer) delete [] *buffer;
        DWORD bufferLength=0;
        TCHAR *domainName;
        DWORD domainNameLength=0;
        SID_NAME_USE peUse;
        bool ok;

        LookupAccountSid(NULL,pSid,NULL,&bufferLength,NULL,&domainNameLength,&peUse);
        *buffer = new TCHAR[bufferLength];
        domainName = new TCHAR[domainNameLength];
        ok=LookupAccountSid(NULL,pSid,*buffer,&bufferLength,domainName,&domainNameLength,&peUse);
        delete [] domainName;

        return ok;
}


BOOL GetProcessUserName(String *name,unsigned long processID)
{
    HANDLE hProcess = OpenProcess( PROCESS_QUERY_INFORMATION |
                                        PROCESS_VM_READ,
                                        FALSE, processID );


    HANDLE hToken    = NULL;
    DWORD buffLength;
    TOKEN_USER *tokenUser =NULL;
    BOOL result=true;
    TCHAR *nameC = NULL;

    
    if (!OpenProcessToken(hProcess,
                          TOKEN_QUERY,
                          &hToken ))
        result=false;
    //dostajemy ilosc potrzebnego miejscaa
    GetTokenInformation(hToken,TokenUser,NULL,0,&buffLength);

    tokenUser = (PTOKEN_USER) GlobalAlloc( GPTR, buffLength );


    if(!GetTokenInformation(hToken,TokenUser,tokenUser,buffLength,&buffLength))
        result=false;

    GetNameFromSid(tokenUser->User.Sid,&nameC);

    *name=nameC;

    if(tokenUser)GlobalFree( tokenUser );
    if(nameC) delete [] nameC;
    CloseHandle(hToken);

    return result;
}



void RysujRamke(TCanvas* Canvas,RECT a,char WindowName[80])
{
    Canvas->Pen->Color = clRed;
    Canvas->Pen->Width = 5;
    Canvas->Brush->Color = clBtnFace;
    Canvas->Font->Size=10;
    Canvas->TextOutA(a.left,a.top,WindowName);
    Canvas->MoveTo(a.left,a.top);
    Canvas->LineTo(a.left,a.bottom);
    Canvas->LineTo(a.right,a.bottom);
    Canvas->LineTo(a.right,a.top);
    Canvas->LineTo(a.left,a.top);
}



bool CALLBACK EnumWindowsProc(HWND hWnd, char ktoreOkna)
{
 //tylko do ktoreOkna = 2
 char WindowName[80], ClassName[80];
 char user_name[128];
 DWORD len = 128;
 String login;
 unsigned long pid;
 GetUserName(user_name, &len);
 String user=(String)user_name;

 //pozycja okna
 WINDOWPLACEMENT wd;
 UINT nCurShow;
 RECT a;
 GetWindowRect(hWnd,&a);
 GetWindowText(hWnd, WindowName, 80);
 GetClassName(hWnd, ClassName, 80);
 GetWindowThreadProcessId(hWnd,&pid);
 GetProcessUserName(&login,pid);

 //ramka
 Graphics::TBitmap *bmp=Form2->Image1->Picture->Bitmap;
 if(ktoreOkna == 0) RysujRamke(bmp->Canvas,a,WindowName);
 if(IsWindowVisible(hWnd) && ktoreOkna == 1) RysujRamke(bmp->Canvas,a,WindowName);
 if(login==user && ktoreOkna == 2) RysujRamke(bmp->Canvas,a,WindowName);
 return true;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    Form2->Image1->Visible=false;
    Form2->Refresh();

    //zrzut ekranu
    Graphics::TBitmap *Bmp=Form2->Image1->Picture->Bitmap;
    TCanvas &PulpitCanvas = *new TCanvas();
    PulpitCanvas.Handle = GetDC(0);
    Bmp->Width = Screen->Width;
    Bmp->Height = Screen->Height;
    Bmp->Canvas->CopyRect(Rect(0, 0, Bmp->Width, Bmp->Height), &PulpitCanvas,
                          Rect(0, 0, Bmp->Width, Bmp->Height));
    delete &PulpitCanvas;

    //rysowanie ramek
    EnumWindows((WNDENUMPROC)EnumWindowsProc,(LPARAM)ComboBox1->ItemIndex);

    Form2->Image1->Visible=true;
    Form2->Show();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
    static int pierwszyRaz=true;
    if(pierwszyRaz)
    {
        Button1Click(NULL);
        Beep(100,100);
        pierwszyRaz=false;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    Graphics::TBitmap *Bmp=Form2->Image1->Picture->Bitmap;
    Bmp->SaveToFile("ekran.bmp");
}
//---------------------------------------------------------------------------

