//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
#include "Unit4.h"
#include "Unit5.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SHDocVw_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
TKonto *KontoP;

//---------------------------------------------------------------------------

__fastcall TKonto::TKonto()
{
  NPort=new AnsiString;
  NPortS=new AnsiString;
  NLogin=new AnsiString;
  NSerwer=new AnsiString;
  NSerwerS=new AnsiString;
  NHaslo=new AnsiString;
  NAutent=new TAuthenticationType;
}

//---------------------------------------------------------------------------

__fastcall TKonto::~TKonto()
{
   delete(NPort);
   delete(NLogin);
   delete(NSerwer);
   delete(NSerwerS);
   delete(NHaslo);
   delete(NPortS);
   delete(NAutent);
}

//---------------------------------------------------------------------------

unsigned int __fastcall TKonto::RozmiarSkrzynki()
{
  //proboje pobrac rozmiar skrzynki
  try
  {
    sSkrzynki=(Form1->IdPOP31->Connected()) ? Form1->IdPOP31->RetrieveMailBoxSize()/1024 : 0;
    return sSkrzynki;
  }
  catch(Exception &e)
  {
  //jesli pojawi sie ponizszy charakterystyczny wyjatek, wykonuje operacje takie jak przy logowaniu
    if(e.Message=="Connection Closed Gracefully.")
    {
      Form1->UstawParametry();
      // a jesli to sie nie uda wyswietlam blad
      if(!SprawdzPolaczenie()) ShowMessage("Blad polaczenia");
      // jesli nie pojawil sie problem ze wzowieniem polaczenia mam nadzieje zwrocic poprawny rozmiar(wywolanie rekurencyjne)
      return RozmiarSkrzynki();
    }
    //jesli mamy stycznosc z innym wyjatkiem
    else
    {
      ShowMessage("Wystapil blad:\n"+e.Message);
      return 0;
    }
  }
}

//---------------------------------------------------------------------------

unsigned int __fastcall TKonto::RozmiarWiadomosci(int MsgId)
{
  //proba pobrania rozmiaru wiadomosci
  if(Form1->IdPOP31->Connected())
    try
    {
      return Form1->IdPOP31->RetrieveMsgSize(MsgId)/1024;
    }
    catch(Exception &e)
    {
      if(e.Message=="Connection Closed Gracefully.")
      {
        Form1->UstawParametry();
        if(!SprawdzPolaczenie()) ShowMessage("Blad polaczenia");
        return RozmiarWiadomosci(MsgId);
      }
      else
      {
        ShowMessage("Wystapil blad:\n"+e.Message);
        return 0;
      }
    }
    else
      return 0;
}

//---------------------------------------------------------------------------

unsigned int __fastcall TKonto::LiczbaWiadomosci()
{
  //proba pobrania liczby wiadomosci
  unsigned int nWiadomosci;
  if(Form1->IdPOP31->Connected())
    try
    {
      nWiadomosci=Form1->IdPOP31->CheckMessages();
    }
    catch(Exception &e)
    {
      if(e.Message=="Connection Closed Gracefully.")
      {
        Form1->UstawParametry();
        if(!SprawdzPolaczenie()) ShowMessage("Blad polaczenia");
          return LiczbaWiadomosci();
      }
      else
      {
        ShowMessage("Wystapil blad:\n"+e.Message);
        return 0;
      }
    }
  else
    nWiadomosci=0;
  return nWiadomosci;
}

//---------------------------------------------------------------------------

bool __fastcall TKonto::SprawdzPolaczenie()     //POP3
{
  // jesli nie jest nawiazane polaczenie z serwerem POP3
  if(!Form1->IdPOP31->Connected())
  {
    try
    {
      Form1->StatusBar1->SimpleText="Odbieranie poczty - sprawdzanie polaczenia...";

      Form1->IdPOP31->Connect();
      Form1->StatusBar1->SimpleText="Odbieranie poczty - polaczono z serwerem";
      //ustawienie stanu poczatkowego wiadomosci ("wyzerowawnie")
      return 1;
    }
    catch (Exception &e)
    {
      Form1->StatusBar1->SimpleText="Odbieranie poczty - nie podlaczono";
      ShowMessage("Nie mozna polaczyc sie z serwerem "+ Form1->IdPOP31->Host+"\n"+e.Message);
      return 0; //false
    }
  }
  return 1;
}

//---------------------------------------------------------------------------

bool __fastcall TKonto::SprawdzPolaczenieS()    //SMTP
{
  //jesli nie jest nawiazane polaczenie z serwerem SMTP
  if(!Form1->IdSMTP1->Connected())
  {
    try
    {
      Form1->StatusBar1->SimpleText="SMTP - laczenie z serwerem...";

      Form1->IdSMTP1->Connect();
      Form1->StatusBar1->SimpleText="SMTP - polaczono z serwerem...";
      return 1;
    }
     catch (Exception &e)
    {
      ShowMessage("SMTP - nie mozna polaczyc sie z serwerem "+ Form1->IdSMTP1->Host+"\n"+e.Message);
      Form1->StatusBar1->SimpleText="SMTP - nie podlaczono z "+ Form1->IdSMTP1->Host;
      return 0; //false
    }
  }
  return 1;
}

//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
//utworzenie obiektu Konto
    KontoP=new(TKonto);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UstawParametry()  //Parametry POP3
{
    IdPOP31->Host=KontoP->PobierzSerwer();
    IdPOP31->Port=StrToInt(KontoP->PobierzPort());
    IdPOP31->UserId=KontoP->PobierzLogin();
    IdPOP31->Password=KontoP->PobierzHaslo();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::UstawParametryS()  //Parametry SMTP
{
    IdSMTP1->Host=KontoP->PobierzSerwerS();
    IdSMTP1->Port=StrToInt(KontoP->PobierzPortS());
    IdSMTP1->UserId=KontoP->PobierzLogin();
    IdSMTP1->Password=KontoP->PobierzHaslo();
    IdSMTP1->AuthenticationType=KontoP->PobierzAutent();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
   //ustawienie wartosci pol tekstowych - informacje o porcie, nazwie serwera, loginie
   SPort->Caption=KontoP->PobierzPort();
   SSerwer->Caption=KontoP->PobierzSerwer();
   SLogin->Caption=KontoP->PobierzLogin();
   CheckBox1->Visible=false;
   Button5->Visible=false;

   //wlaczenie lub wylaczenie kontrolek i widocznosci informacji o koncie w zaleznosci od tego, czy zostalo uzyskane polaczenie
    if(IdPOP31->Connected())
    {
      Button2->Visible=true;
      Button3->Visible=true;
      StaticText4->Caption="Masz "+IntToStr(KontoP->LiczbaWiadomosci())+" wiadomosci";
      StaticText5->Caption="Rozmiar skrzynki";
      SRozmiar->Caption=IntToStr(KontoP->RozmiarSkrzynki())+"KB";
    //podtrzymanie polaczenia, zabezpieczenie przed utrata polaczenia
      IdPOP31->KeepAlive();
    }
    else
    {
      SPort->Caption="";
      Button2->Visible=false;
      Button3->Visible=false;
      Button4->Visible=false;
      StaticText4->Caption="";
      StaticText5->Caption="";
      SRozmiar->Caption="";
      Form3->Visible=false;
    }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Oprogramie1Click(TObject *Sender)
{
     MessageBox(Application->Handle,"Klient Poczty Elektronicznej\n\nWersja  1.1\nAutor   236424","O programie",MB_OK);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Zakocz1Click(TObject *Sender)
{
     if(IdPOP31->Connected())
     {
       if(MessageBox(Application->Handle,"Nie wylogowales sie. Czy na pewno chcesz zakonczyc prace?","Pytanie",MB_YESNOCANCEL)!=IDYES)
         return;
     }
     Close();    //wywolanie zdarzenia OnClose()
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Zaloguj1Click(TObject *Sender)
{
  //formularz logowania
  Form2->Visible=true;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Wyloguj1Click(TObject *Sender)
{
    if( IdPOP31->Connected() )
    {
      //jesli lista wiadomosci nie jest pusta
      if(ListView1->Items->Count)
      {
        unsigned int nWiadomosci=KontoP->LiczbaWiadomosci();
        AnsiString sciezka;
        for(unsigned int j=0; j<nWiadomosci; j++)
        {
          IdMessage1=(TIdMessage*)ListView1->Items->Item[j]->Data;

          sciezka=ExtractFileDir(Application->ExeName)+"\\html\\"+IntToStr(j);

          //przejrzenie wszystkich skladowych wiadomosci
          for(int i=0;i<IdMessage1->MessageParts->Count;i++)
          {
              //usuniecie wszystkich zalacznikow
              if(IdMessage1->MessageParts->Items[i]->DisplayName=="TIdAttachment")
              {
                TIdAttachment *zal = (TIdAttachment*)IdMessage1->MessageParts->Items[i];
                DeleteFile(sciezka+"\\"+zal->FileName);
              }
          }
          //usuniecie strony html wiadomosci
          DeleteFile(sciezka+"\\index.html");
          //usuniecie tymczasowego katalogu, przeznaczonego na wiadomosci
          RemoveDirectory(sciezka.c_str());
        }
      }
      KontoP->UstawSerwer("");
      KontoP->UstawLogin("");
      KontoP->UstawHaslo("");
      UstawParametry();
      IdPOP31->Disconnect();
      ListView1->Items->Clear();
      ListBox1->Items->Clear();
      FormActivate(Form1);
      StatusBar1->SimpleText="Wylogowano";
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender) //pobranie wiadomosci
{
  //"wyzerowanie" strony w przeznaczonej na to formie
  Form3->CppWebBrowser1->Navigate2(0,0,0);
  Form3->Visible=false;
  //rozlaczenie sie przed pobraniem wiadomosci
  //istotne, gdy uprzednio zaznaczono wiadomosci do skasowania- aby sie to dokonalo, niezbedne rozlaczenie
  //         gdy zmienila sie liczba wiadomosci w skrzynce a zarazem wielkosc skrzynki - aktualizacja tych wartosci
  IdPOP31->Disconnect();
  //wyczyszczenie listy zalacznikow
  //istotne, gdy dotyczy zalacznikow usunietej wiadomosci
  ListBox1->Clear();

  if( KontoP->SprawdzPolaczenie())
  {
    //proba pobrania wiadomosci
     try
     {
       FormActivate(Form1);
       AnsiString sciezka=ExtractFileDir(Application->ExeName)+"\\html\\";
       CreateDirectory(sciezka.c_str(),0);
       Form1->StatusBar1->SimpleText="Odbieranie poczty - pobieranie listy wiadomosci";
       Button4->Visible=true;

       int zalaczniki, liczbaZalacznikow,lWiadomosci;
       TListItem *Lista;

       IdMessage1->Clear();
       ListView1->Items->Clear();
       lWiadomosci=KontoP->LiczbaWiadomosci();

       //pobranie z serwera i utworzenie wiadomosci
       for (int i=1; i<=lWiadomosci; i++)
       {
          IdMessage1 = new TIdMessage(ListView1);
          //"przechwycenie" wiadomosci
          IdPOP31->Retrieve(i,IdMessage1);
          //liczba skladowych wiadomosci
          liczbaZalacznikow=IdMessage1->MessageParts->Count;
          Lista = ListView1->Items->Add();
          //pobranie informacji o nadawcy
          Lista->Caption = IdMessage1->From->Address;
          //informacje o temacie wiadomosci
          Lista->SubItems->Add(IdMessage1->Subject);
          //informacje o dacie odebrania wiadomosci
          Lista->SubItems->Add(IdMessage1->Date.DateTimeString());
          //wyznaczenie rozmiaru wiadomosci w KB
          Lista->SubItems->Add(IntToStr(KontoP->RozmiarWiadomosci(i))+" KB");

          zalaczniki=0;
          //wyznaczenie rzeczywistej liczby zalacznikow (przypadek gdy MessagePart jest rowne TIdAttachment)
          for(int j=0; j<liczbaZalacznikow;j++)
           if(IdMessage1->MessageParts->Items[j]->DisplayName=="TIdAttachment")
             zalaczniki++;
         //informacje o liscie zalacznikow
         Lista->SubItems->Add(IntToStr(zalaczniki));
         Lista->Data =IdMessage1;
       }
       Form1->StatusBar1->SimpleText="Odbieranie poczty - pobrano wiadomosci";
     }
     //wylapanie wyjatku - nie powiodlo sie pobranie wiadomosci
     catch (Exception &e)
     {
       if(e.Message=="Connection Closed Gracefully.")
       {
         Form1->UstawParametry();
         if(!KontoP->SprawdzPolaczenie()) ShowMessage("Blad polaczenia");
       }
      else
        ShowMessage("Wystapil blad:\n"+e.Message);
     }
  }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::ListView1SelectItem(TObject *Sender,
      TListItem *Item, bool Selected)
{
  //wyczyszczenie przestrzeni na tresc wiadomosci
  Memo1->Lines->Clear();
  if(Selected && Item)
  {
     try
     {
        ListBox1->Clear();
        CheckBox1->Visible=true;
        Button5->Visible=true;
        IdMessage1=(TIdMessage*)Item->Data;
        //zmienna przechowujaca tekst wiadomosci
        TIdText *IdText;
        //ustalenie sciezki na tymczasowe przechowywanie strony
        AnsiString sciezka=ExtractFileDir(Application->ExeName)+"\\html\\"+IntToStr(Item->Index);;
        //przejrzenie wszystkich skladowych wiadomosci
        for(int i=0;i<IdMessage1->MessageParts->Count;i++)
        {
            if(IdMessage1->MessageParts->Items[i]->DisplayName=="TIdText")
            {
               IdText = (TIdText*)IdMessage1->MessageParts->Items[i];
               //konwersja tresci na utf8
               if(CheckBox1->Checked)
                Memo1->Lines->Text=Utf8ToAnsi(IdText->Body->Text);
               else
                 Memo1->Lines->AddStrings(IdText->Body);
            }
            //utworzenie katalogu dla danej wiadomosci
            CreateDirectory(sciezka.c_str(),0);
            //dodanie do listy zalacznikow
            if(IdMessage1->MessageParts->Items[i]->DisplayName=="TIdAttachment")
            {
              TIdAttachment *zal = (TIdAttachment*)IdMessage1->MessageParts->Items[i];
              zal->SaveToFile(sciezka+"\\"+zal->FileName);
              ListBox1->Items->Add(zal->FileName);
            }
        }
        //zapisanie pliku html wiadomosci
        IdText->Body->SaveToFile(sciezka+"\\index.html");
     }
     catch(Exception &e)
     {
       if(e.Message=="Connection Closed Gracefully.")
       {
         Form1->UstawParametry();
         if(!KontoP->SprawdzPolaczenie()) ShowMessage("Blad polaczenia");
       }
       else
         ShowMessage("Wystapil blad:\n"+e.Message);
     }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SaveDialog1CanClose(TObject *Sender,
      bool &CanClose)
{
     int j=0;
     //zapis wybranych zalacznikow
     for(int i=0;i<IdMessage1->MessageParts->Count;i++)
     {
       if(IdMessage1->MessageParts->Items[i]->DisplayName=="TIdAttachment")
       {
         TIdAttachment *zal = (TIdAttachment*)IdMessage1->MessageParts->Items[i];
         if(ListBox1->ItemIndex==j) zal->SaveToFile(SaveDialog1->FileName);
              j++;
            }
        }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender) //wybranie akcji zapisu zalacznika
{
    if(ListBox1->ItemIndex!=-1)
    {
       SaveDialog1->FileName=ListBox1->Items->Strings[ListBox1->ItemIndex];
       SaveDialog1->Execute();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)  //usuniecie wybranych wiadomosci
{
   //"wyzerowanie" wyswietlanej strony - na wypadek, gdyby usuwana wiadomosc dotyczyla wyswietlanej w trzeciej formie
   Form3->CppWebBrowser1->Navigate2(0,0,0);
   Form3->Visible=false;
   unsigned int doUsuniecia=0;
   unsigned int nWiadomosci=KontoP->LiczbaWiadomosci();

   //wychwycenie wiadomosci do usuniecia i oznaczenie ich celem usuniecia
   for(unsigned int i=0; i< nWiadomosci; i++)
   {
     if(ListView1->Items->Item[i]->Checked) {
       if(IdPOP31->Delete(i+1))
         doUsuniecia++;
       }

   }
   //jesli sa jakies wiadomosci zaakceptowane do usuniecia, zostana usuniete i wykonanie dzialania jak przy nacisnieciu przycisku "Pobierz wiadomosci"
   if(doUsuniecia)
   {
     AnsiString text="Zaznaczono "+IntToStr(doUsuniecia)+" wiadomosci. Czy chcesz je usunac?";
     if(MessageBox(Application->Handle,text.c_str(),"Pytanie",MB_YESNOCANCEL)!=IDYES)
       IdPOP31->Reset();
     else
     {
       AnsiString sciezka;
       for(unsigned int j=0; j< nWiadomosci; j++)
       //usuniecie takze plikow zwiazanych z ostatnimi n wiadomosciami, gdzie n oznacza ilosc wiadomosci do usuniecia
       //wazne, gdyz po usunieciu wiadomosci, zmienia sie numeracja pozostalych wiadomosci
       //dlatego, jesli mamy 9 wiadomosci i usuniemy 5, to po usunieciu jej, 9 wiadomosc stanie sie 8
       //8 bedzie calkowita liczba wiadomosci w skrzynce, gdy wiec wywolam funkcje wyloguj, zostana usuniete pliki zwiazane z wiadomosciami od 1 do 8
       //gdyby nie usuwnie w tym momencie tymczasowych plikow, pliki zwiazane z 9 wiadomoscia(przed zmiana jej numeru) pozostana na dysku, nie zostana objete przez funkcje wyloguj
         if(ListView1->Items->Item[j]->Checked || j>=nWiadomosci-doUsuniecia-1)
         {
           IdMessage1=(TIdMessage*)ListView1->Items->Item[j]->Data;
           sciezka=ExtractFileDir(Application->ExeName)+"\\html\\"+IntToStr(j);
           //przejrzenie wszystkich skladowych wiadomosci
           for(int i=0;i<IdMessage1->MessageParts->Count;i++)
            //usuniecie wszystkich zalacznikow
            if(IdMessage1->MessageParts->Items[i]->DisplayName=="TIdAttachment")
            {
              TIdAttachment *zal = (TIdAttachment*)IdMessage1->MessageParts->Items[i];
              //usuniecie zalacznikow
              DeleteFile(sciezka+"\\"+zal->FileName);
            }
           //usuniecie strony html wiadomosci
           DeleteFile(sciezka+"\\index.html");
           //usuniecie tymczasowych katalogow, przeznaczonych na wiadomosci
           RemoveDirectory(sciezka.c_str());
         }
       //pobranie wiadomosci
       Button2Click(Form1);
     }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)  //wyswietlenie strony html wiadomosci
{
   //uzycie wariantu ze wzgledu na skladnie metody Navigate2
   TVariant address;
   //pobranie pelnej sciezki aplikacji
   AnsiString sciezka=ExtractFileDir(Application->ExeName);
   //pelen adres wybranej wiadomosci
   address="file:///"+sciezka+"\\html\\"+StrToInt(ListView1->Selected->Index)+"\\index.html";

   //wyswietlenie w trzeciej formie wybranej strony w formacie html
   Form3->Visible=true;
   Form3->CppWebBrowser1->Navigate2(&address,0,0);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)  //wyslanie wiadomosci
{
   //forma z formularzem wysylania wiadomosci
   Form4->Visible=true;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   Wyloguj1Click(Form1);
   delete(IdMessage1);
   delete(KontoP);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Pomoc2Click(TObject *Sender)
{
   ShowMessage("Kontakt: 236424@fizyka.umk.pl");
}
//---------------------------------------------------------------------------

