//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#include <system.hpp>
#include <mmsystem.h>
#pragma hdrstop
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------

extern "C" __declspec(dllexport) void Laduj(AnsiString Plik);
extern "C" __declspec(dllexport) HWND uchwyt(HWND uchwytokna2);
extern "C" __declspec(dllexport) void Play();
extern "C" __declspec(dllexport) void OdtwarzajOdPozycji(int pozycja);
extern "C" __declspec(dllexport) void Pause();
extern "C" __declspec(dllexport) void Stop();
extern "C" __declspec(dllexport) void Nast();
extern "C" __declspec(dllexport) void Pop();
extern "C" __declspec(dllexport) int Dlugosc(AnsiString Plik);
extern "C" __declspec(dllexport) int Pozycja();
extern "C" __declspec(dllexport) void Glosnosc(int vol);
extern "C" __declspec(dllexport) void UstawPozycje(int pozycja);
extern "C" __declspec(dllexport) void Zamknij();
extern "C" __declspec(dllexport) void formatczasu();
extern "C" __declspec(dllexport) AnsiString zmiana_formatu_czasu(int czas);

#pragma argsused
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fwdreason, LPVOID lpvReserved)
{

        return 1;
}

HWND uchwytokna;
AnsiString sciezka;

HWND uchwyt(HWND uchwytokna2)
        {
                uchwytokna=uchwytokna2;
                return uchwytokna2;
        }

AnsiString zmiana_formatu_czasu(int czas)
        {

          int godz = czas/3600;
          int min = (czas-godz*3600)/60;
          int sec = (czas-godz*3600-min*60);
          AnsiString wynik = IntToStr(godz)+":"+IntToStr(min)+":"+IntToStr(sec);
          return wynik;
        }

void formatczasu()
        {
                AnsiString polecenie = "set " + sciezka + " time format milliseconds";
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

void Laduj(AnsiString Plik)
        {
                sciezka="\""+Plik+"\"";
                AnsiString polecenie = "open " + sciezka + " type mpegvideo";
                mciSendString(polecenie.c_str(),NULL,0,0);
                formatczasu();

        }

void Zamknij()
        {
                AnsiString polecenie = "close " + sciezka;
                mciSendString(polecenie.c_str(),NULL,0,0);
        }


void Play()
        {
                AnsiString polecenie = "play " + sciezka + " notify";
                mciSendString(polecenie.c_str(),NULL,0,uchwytokna);

        }

void Pause()
        {

         AnsiString polecenie = "stop " + sciezka ;
         mciSendString(polecenie.c_str(),NULL,0,0);

        }

void UstawPozycje(int pozycja)
        {
                AnsiString polecenie = "seek " + sciezka + " to " + pozycja;
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

void OdtwarzajOdPozycji(int pozycja)
{
                AnsiString polecenie = "play " + sciezka + " from " + pozycja;
                mciSendString(polecenie.c_str(),NULL,0,0);
}

void Stop()
        {
                Pause();
                UstawPozycje(0);
        }

int Dlugosc(AnsiString Plik)
        {
                char buffor[128];
                sciezka="\""+Plik+"\"";
                AnsiString polecenie = "status " + sciezka + " length";
                mciSendString(polecenie.c_str(),buffor,128,0);
                int dlugosc=atoi(buffor)/1000;
                return dlugosc;
        }

int Pozycja()
        {
                char buffor[128];
                AnsiString polecenie = "status " + sciezka + " position";
                mciSendString(polecenie.c_str(),buffor,128,0);
                int pozycja=atoi(buffor)/1000;
                return pozycja;
        }

void Glosnosc(int vol)
        {
          AnsiString polecenie = "setaudio " + sciezka + " volume to " + vol;
          mciSendString(polecenie.c_str(),0,0,0);
        }

//---------------------------------------------------------------------------


