//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#include <Wbemidl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------

#pragma argsused
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fwdreason, LPVOID lpvReserved)
{
   return 1;
}
//---------------------------------------------------------------------------

#include "WMIDll.h"
/*
class __declspec(dllexport) WMIinfo
{
   public:
      WMIinfo();
      ~WMIinfo();
      bool GetSucces();
      AnsiString GetProcessorName();
      AnsiString GetGraphicsName();
      AnsiString GetSystemName();
      int GetRAMSize();
      int GetDiskSize();
      void GetProcessorInfo(TStrings *stringList);
      void GetBiosInfo(TStrings *stringList);
      void GetPhysicalMemoryInfo(TStrings *stringList);
      void GetMonitorInfo(TStrings *stringList);
      void GetKeyboardInfo(TStrings *stringList);
      void GetUSBInfo(TStrings *stringList);
      void GetCDROMInfo(TStrings *stringList);
      void GetDiskInfo(TStrings *stringList);
      void GetDMAInfo(TStrings *stringList);
      void GetTemperature(TStrings *stringList);
      void GetIRQInfo(TStrings *stringList);
      void GetCacheMemoryInfo(TStrings *stringList);
      void GetPrinterInfo(TStrings *stringList);
      void GetBatteryInfo(TStrings *stringList);
      void GetPnPInfo(TStrings *stringList);
      void GetFanInfo(TStrings *stringList);
      void GetGraphicsInfo(TStrings *stringList);
      void GetBusInfo(TStrings *stringList);
      void GetMotherBoardInfo(TStrings *stringList);
      void GetSoundDeviceInfo(TStrings *stringList);
      void GetSerialPortAdapterInfo(TStrings *stringList);
      void GetNetworkAdapterInfo(TStrings *stringList);
   private:
      bool succes;
      void GetInfo(TStrings *stringList,AnsiString about);
      void StringListCopy(TStrings *to, TStrings* from);
};
*/

WMIinfo::WMIinfo()
{
   // najpierw musimy zarejestrowac ochrone i ustawic domyslne wartosci
   // ochrony jak dla kazdego obiektu COM
   CoInitialize(NULL);
   if(CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_PKT,
   RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE, 0) != S_OK)
   {
      ShowMessage("Nie powiodo si inicjowanie interfejsu WMI");
      succes=false;
   }
   else
      succes=true;
}

WMIinfo::~WMIinfo()
{
   // musimy wyrejestrowac ochrone aplikacji
   CoUninitialize();
}

bool WMIinfo::GetSucces()
{
   return succes;
}

AnsiString WMIinfo::GetSystemName()
{
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from Win32_MotherboardDevice");
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if((AnsiString)wcName=="SystemName")
                                 return ASValue;
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }
   return 0;
}

int WMIinfo::GetDiskSize()
{
   long double SIZE=0;
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from Win32_DiskDrive");
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if((AnsiString)wcName=="Size")
                                 SIZE+=StrToInt64(ASValue);
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }
   SIZE=SIZE/1024;
   SIZE=SIZE/1024;
   return (int)(SIZE/1024);
}


int WMIinfo::GetRAMSize()
{
   long double SIZE=0;
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from Win32_PhysicalMemory");
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if((AnsiString)wcName=="Capacity")
                                 SIZE+=StrToInt64(ASValue);
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }
   SIZE=SIZE/1024;
   return (int)SIZE;
}

AnsiString WMIinfo::GetGraphicsName()
{
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from Win32_VideoController");
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if((AnsiString)wcName=="Name")
                                 return ASValue;
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }
   return 0;
}


AnsiString WMIinfo::GetProcessorName()
{
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from Win32_Processor");
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if((AnsiString)wcName=="Name")
                                 return ASValue;
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }
   return 0;
}


void WMIinfo::GetMotherBoardInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_MotherboardDevice");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o pycie gwnej nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetSoundDeviceInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_SoundDevice");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o urzdzeniu dwiku nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetSerialPortAdapterInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_SerialPort");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o portach szeregowych nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetNetworkAdapterInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_NetworkAdapter");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o karcie sieciowej nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetBusInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Bus");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o magistrali nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetFanInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Fan");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o wentylatorze nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetPnPInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_PnPEntity");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o jednostkach Plug and Play nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetBatteryInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Battery");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o baterii nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetCacheMemoryInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_CacheMemory");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o pamici cahce nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetPrinterInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Printer");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o drukarce nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetGraphicsInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_VideoController");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o grafice nie powiodo si");
   }
   succes=tempSucces;
}


void WMIinfo::GetIRQInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_IRQResource");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o przerwaniach nie powiodo si");
   }
   succes=tempSucces;
}



void WMIinfo::GetDiskInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_DiskDrive");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o dysku nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetTemperature(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_TemperatureProbe");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o temperaturze nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetDMAInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_DMAChannel");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o DMA nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetCDROMInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_CDROMDrive");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o CDROM nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetUSBInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_USBController");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o USB nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetKeyboardInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Keyboard");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o klawiaturze nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetMonitorInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_DesktopMonitor");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o monitorze nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetPhysicalMemoryInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_PhysicalMemory");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o pamieci fizycznej nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetBiosInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_BIOS");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o BIOS nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetProcessorInfo(TStrings *stringList)
{
   bool tempSucces=succes;
   GetInfo(stringList,"Win32_Processor");
   if (!succes)
   {
      ShowMessage("Pobieranie informacji o procesorze nie powiodo si");
   }
   succes=tempSucces;
}

void WMIinfo::GetInfo(TStrings *stringList, AnsiString about)
{
   WideString ws=WideString(about); // przetworz na kodowanie Unicode
   // uzyskujemy wskaznik do interfejsu WMI
   IWbemLocator *WbemLocator=0;
   // sprawdzamy czy da sie stworzyc IWbemLocator
   if(CoCreateInstance(CLSID_WbemAdministrativeLocator, NULL,
            CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER, IID_IUnknown,
            (void**)&WbemLocator) == S_OK)
   {
      IWbemServices *WbemServices=0;
      // polaczenie sie z WMI przez metode IWbemLocator::ConnectServer
      // ktora pobiera adres interfejsu IWebServices
      // domyslna przestrzen nazw to //  root\default
       WideString Namespace = WideString("root\\cimv2");
       if(WbemLocator->ConnectServer(Namespace, NULL, NULL, NULL, 0, NULL,
         NULL, &WbemServices) == S_OK)
       {
         // udalo sie polaczyc z WMI
          IEnumWbemClassObject *EnumClassObject=0;
          // obiekt EnumClassObject dostajemy z metody WbemServices->ExecQuery
           WideString WQL = WideString("WQL"); //WMI Query Language
           WideString Query = WideString("Select * from ") + ws;
           // pobieramy obiekt do zapytan
           if(WbemServices->ExecQuery(WQL, Query, WBEM_FLAG_RETURN_IMMEDIATELY,
                                    NULL, &EnumClassObject) == S_OK)
           {
               // interfejs mogacy czytac z WMI
               IWbemClassObject *ClassObject=0;
               ULONG Count = 1;
               ULONG returned;
               if(EnumClassObject->Reset() == S_OK) // przywrocenie kolejnosci wyliczania od poczatku
               {
                  int EnumIndex = 0;
                  // wyliczaj nastepne obiekty
                  while(EnumClassObject->Next(WBEM_INFINITE, Count, &ClassObject, &returned) == S_OK)
                  {
                     SAFEARRAY *Names=0;  // tablica mogaca zawierac wskazniki do obiektow ze sterty zapewnia wysoki poziom bezpieczenstwa
                     // obiekty COM musza przekazywac dane do takiej tablicy
                     // pobierz nzawe
                     if(ClassObject->GetNames(NULL, WBEM_FLAG_ALWAYS | WBEM_MASK_CONDITION_ORIGIN, NULL, &Names) == S_OK)
                     {
                        long borderLow,borderUp;
                        SafeArrayGetLBound(Names, 1, &borderLow); // ustaw dolna i gorna granice tablicy Names na borderLow i borderUp
                        SafeArrayGetUBound(Names, 1, &borderUp);
                        for(long index=borderLow; index<=borderUp; index++)
                        {
                           long aindex = index;
                           wchar_t *wcName=0;
                           VARIANT Value;  // typ zmienny
                           VariantInit(&Value);   // inicjalizujemy zmienna Variant
                           // pobierz element z tablicy
                           SafeArrayGetElement(Names, &aindex, &wcName);

                           BSTR bs=SysAllocString(wcName); // binary string
                           HRESULT Result=ClassObject->Get(bs, 0, &Value, NULL, 0);
                                             SysFreeString(bs);

                           if(Result == S_OK)
                           {
                              AnsiString ASValue;
                              Variant Var = *(Variant*)&Value;
                              if(Var.IsArray()) // jesli jest tablica
                              {
                                 for(int i=Var.ArrayLowBound(); i<=Var.ArrayHighBound(); i++)
                                 {
                                    Variant Tmp=Var.GetElement(i);
                                    if(!ASValue.IsEmpty()) ASValue += ", ";
                                       ASValue += VarToStr(Tmp);
                                 }
                              }
                              else  // jesli Var nie jest tablica
                                 ASValue=VarToStr(Var);
                               if(!ASValue.IsEmpty())
                                try
                                {
                                stringList->Add(AnsiString(wcName) + ": " + ASValue);
                                // stringList->Add(Translate(AnsiString(wcName)) + ": " + ASValue); // tlumacz na jezyk polski
                                } catch (Exception &ex)
                                {
                                    Application->ShowException(&ex);
                                }
                           }
                            VariantClear(&Value);
                            SysFreeString(wcName);
                        }
                     }
                     if(Names) SafeArrayDestroy(Names);
                        EnumIndex++;
                  }
                  if(ClassObject) ClassObject->Release();
                  if(EnumClassObject) EnumClassObject->Release();
                  if(WbemServices) WbemServices->Release();
                  if(WbemLocator) WbemLocator->Release();
               }
               else
               {
                  ShowMessage("Nie udao si przywrci kolejnoci wyliczania");
                  succes=false;
               }
           }
           else
           {
               ShowMessage("Nie udalo sie pobrac obiektu IEnumClassObject");
               succes=false;
           }
       }
       else
       {
         ShowMessage("Nie udao sie nawiza poczenia");
         succes=false;
       }
   }
   else
   {
      ShowMessage("Nie udalo sie stworzy obiektu IWbemLocator");
      succes=false;
   }

}
