//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "unit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;
//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner) : TForm(Owner), m_card(10, 10, core::suitHearts, core::rankSeven)
{
        this->DoubleBuffered = true;

        ComboBoxSuit->ItemIndex=2;
        ComboBoxRank->ItemIndex=6;
        ComboBoxBack->ItemIndex=3;
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ComboBoxSuitChange(TObject *Sender)
{
        core::suit_t suit = static_cast<core::suit_t>( ComboBoxSuit->ItemIndex );
        m_card.setSuit(suit);

        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ComboBoxRankChange(TObject *Sender)
{
        core::rank_t rank = static_cast<core::rank_t>( ComboBoxRank->ItemIndex );
        m_card.setRank(rank);

        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ComboBoxBackChange(TObject *Sender)
{
        core::back_t back = static_cast<core::back_t>( ComboBoxBack->ItemIndex + 54 );
        m_card.setBack(back);
        
        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::PaintBoxDisplayerPaint(TObject *Sender)
{
        PaintBoxDisplayer->Canvas->Brush->Color = clGreen;
        PaintBoxDisplayer->Canvas->Rectangle(0, 0, PaintBoxDisplayer->Width, PaintBoxDisplayer->Height);
        
        m_card.draw(PaintBoxDisplayer->Canvas->Handle, clGreen);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::PaintBoxDisplayerMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
        if ( X >= m_card.getPosX() && X <= m_card.getPosX() + m_card.getWidth() )
        {
                if ( Y >= m_card.getPosY() && Y <= m_card.getPosY() + m_card.getHeight() )
                {
                        if ( Button == mbLeft )
                        {
                                m_prevX = X;
                                m_prevY = Y;
                                m_isMoving = true;
                        }
                        else if ( Button == mbRight )
                        {
                                this->ButtonTurnClick(Sender);
                        }
                }
        }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::PaintBoxDisplayerMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y)
{
        m_isMoving = false;        
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::PaintBoxDisplayerMouseMove(TObject *Sender, TShiftState Shift, int X, int Y)
{
        if ( m_isMoving )
        {
                int dx = X - m_prevX;
                int dy = Y - m_prevY;

                int newPosX = m_card.getPosX() + dx;
                int newPosY = m_card.getPosY() + dy;

                m_prevX = X;
                m_prevY = Y;

                if ( X > 0 && X < PaintBoxDisplayer->Width )
                {
                        if ( Y > 0 && Y < PaintBoxDisplayer->Height )
                        {
                                if ( newPosX > 0 && newPosX +  m_card.getWidth() < PaintBoxDisplayer->Width )
                                {
                                        if ( newPosY > 0 && + newPosY + m_card.getHeight() < PaintBoxDisplayer->Height )
                                        {
                                                m_card.setPosX(newPosX);
                                                m_card.setPosY(newPosY);
                                
                                                PaintBoxDisplayer->Repaint();
                                        }
                                }
                        }

                }
        }
}
//---------------------------------------------------------------------------


void __fastcall TFormMain::ButtonTurnClick(TObject *Sender)
{
        if ( ComboBoxBack->Enabled )
        {
                ComboBoxSuit->Enabled = true;
                ComboBoxRank->Enabled = true;
                ComboBoxBack->Enabled = false;

                m_card.setMode(core::modeFaceUp); 
        }
        else
        {
                ComboBoxSuit->Enabled = false;
                ComboBoxRank->Enabled = false;
                ComboBoxBack->Enabled = true;

                m_card.setMode(core::modeFaceDown);
        }

        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonSelectClick(TObject *Sender)
{
        if ( m_card.getMode() == core::modeFaceDown )
        {
                this->ButtonTurnClick(Sender);
        }

        if ( m_card.getMode() == core::modeHilite )
        {
                m_card.setMode(core::modeFaceUp);
                ButtonSelect->Caption = "Zaznacz";
        }
        else
        {
                ButtonSelect->Caption = "Odznacz";
                m_card.setMode(core::modeHilite);
        }

        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonGhostClick(TObject *Sender)
{
        ComboBoxSuit->Enabled = false;
        ComboBoxRank->Enabled = false;
        ComboBoxBack->Enabled = false;
        
        m_card.setMode(core::modeGhost);
        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonDeckXClick(TObject *Sender)
{
        ComboBoxSuit->Enabled = false;
        ComboBoxRank->Enabled = false;
        ComboBoxBack->Enabled = false;
        
        m_card.setMode(core::modeDeckX);
        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonDeckOClick(TObject *Sender)
{
        ComboBoxSuit->Enabled = false;
        ComboBoxRank->Enabled = false;
        ComboBoxBack->Enabled = false;
        
        m_card.setMode(core::modeDeckO);
        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonNormalClick(TObject *Sender)
{
        ComboBoxSuit->Enabled = true;
        ComboBoxRank->Enabled = true;
        ComboBoxBack->Enabled = false;

        m_card.setMode(core::modeFaceUp);

        PaintBoxDisplayer->Repaint();
}
//---------------------------------------------------------------------------

