#ifndef core_h__
#define core_h__

#ifdef CARDSCORE_EXPORTS
        #define CARDSCORE_DECLSPEC __declspec(dllexport)
#else
        #define CARDSCORE_DECLSPEC __declspec(dllimport)
#endif

#include <windows.h>

namespace core
{
        const unsigned int c_defaultCardWidth = 71;
        const unsigned int c_defaultCardHeight = 96;

        
        enum rank_t
	{
		rankAce = 0, /* as */
		rankTwo,
		rankThree,
		rankFour,
		rankFive,
		rankSix,
		rankSeven,
		rankEight,
		rankNine,
		rankTen,
		rankJack, /* walet */
		rankQueen, /* dama */
		rankKing /* krl */
	};

	enum suit_t
	{
		suitClubs = 0, /* trefl 'odzie' */
		suitDiamonds, /* karo 'dzwonki' */
		suitHearts, /* kier 'serca' */
		suitSpades /* pik 'wina' */
	};

	enum back_t
	{
		backSky = 54,
		backMineral,
		backFish,
		backFrog,
		backMoonFlower,
		backIsland,
		backSquares,
		backMagenta,
		backSandDunes,
		backSpace,
		backLines,
		backToyCars,
		backUnused,
		backTheX,
		backTheO
	};

	enum mode_t
	{
		modeFaceUp = 0,
		modeFaceDown,
		modeHilite, /* 'zaznaczenie karty' */
		modeGhost, /* miejsce na stos kart */
		modeRemove, /* rysuje tylko tlo o kolorze podanym w color */
		modeInvisibleGhost, /* to samo co ghost */
		modeDeckX,
		modeDeckO
	};

        inline CARDSCORE_DECLSPEC int makeCard( suit_t suit, rank_t rank ) {
                return ( suit + rank * 4 );
        }

	class CARDSCORE_DECLSPEC card_t
	{
	public:
		card_t( int posX, int posY, suit_t suit, rank_t rank, mode_t mode = modeFaceUp );
                card_t( int posX, int posY, back_t back = backFrog );
		virtual ~card_t();

		inline void setRank( rank_t rank ) {
			m_rank = rank;
		}

		inline rank_t getRank() {
			return m_rank;
		}

		inline void setSuit( suit_t suit ) {
			m_suit = suit;
		}

		inline suit_t getSuit() {
			return m_suit;
		}

                inline void setMode(mode_t mode) {
                        m_mode = mode;
                }

                inline mode_t getMode() {
                        return m_mode;
                }

                inline void setPosX(int x) {
                        m_posX = x;
                }

                inline int getPosX() {
                        return m_posX;
                }

                inline void setPosY(int y) {
                        m_posY = y;
                }

                inline int getPosY() {
                        return m_posY;
                }

                inline int getWidth() {
                        return m_width;
                }

                inline int getHeight() {
                        return m_height;
                }

                inline void setBack(back_t back) {
                        m_back = back;
                }

                inline back_t getBack() {
                        return m_back;
                }

                void draw( HDC hdc, unsigned long color );
                void remove(HDC hdc, unsigned long color);
                void move(int dx, int dy);

	private:
		suit_t		m_suit;
		rank_t		m_rank;
                back_t          m_back;
                mode_t          m_mode;

		int		m_posX;
		int		m_posY;

                unsigned int    m_width;
                unsigned int    m_height;
	};
}
#endif // core_h__
 