#include "core.h"
#include "../cardsMicrosoft/cards.h"

using namespace core;

card_t::card_t( int posX, int posY, suit_t suit, rank_t rank, mode_t mode /*= modeFaceUp*/ )
        : m_suit(suit), m_rank(rank), m_mode(mode), m_posX(posX), m_posY(posY)
{
        m_width = c_defaultCardWidth;
        m_height = c_defaultCardHeight;
        m_back = backFrog;
}

card_t::card_t( int posX, int posY, back_t back /*= backFrog*/ )
        : m_back(back), m_posX(posX), m_posY(posY)
{
        m_width = c_defaultCardWidth;
        m_height = c_defaultCardHeight;
}

card_t::~card_t()
{
        
}

void card_t::draw( HDC hdc, unsigned long color )
{
        int card = 0;
        switch ( m_mode )
        {
                case modeFaceUp:
                case modeHilite:
                        card = makeCard(m_suit, m_rank);
                        break;

                case modeFaceDown:
                        card = m_back;
                        break;
        }

        cdtDrawExt(hdc, m_posX, m_posY, m_width, m_height, card, m_mode, color);
}

void card_t::move(int dx, int dy)
{
        m_posX += dx;
        m_posY += dy;
}

void card_t::remove(HDC hdc, unsigned long color)
{
     cdtDraw(hdc, m_posX, m_posY, 0, modeRemove, color);
}
 