unit Complex;

interface

uses SysUtils;

type
  TComplex = class
    private
      Re,Im :Double;
    public
      function Real() :Double;
      function Imag() :Double;
      procedure SetValue(Re,Im :Double); overload;
      procedure SetValue(Value :TComplex); overload;
      constructor Create(Re,Im :Double);
      constructor Zero();
      function Norm() :Double;

      procedure Dodaj(Arg :TComplex);
      procedure Odejmij(Arg :TComplex);
      procedure Pomnoz(Arg :TComplex); overload;
      procedure Pomnoz(Arg :Double); overload;
    end;

//function ComplexZero :TComplex; //tworzy nowy obiekt
function Real(const z :TComplex) :Double;
function Imag(const z :TComplex) :Double;
//function ComplexSuma(const arg1, arg2 :TComplex) :TComplex; //tworzy nowy obiekt
//function ComplexRoznica(const arg1, arg2 :TComplex) :TComplex; //tworzy nowy obiekt
//function ComplexIloczyn(const arg1, arg2 :TComplex) :TComplex; //tworzy nowy obiekt
//function ComplexToStr(const z :TComplex) :String;

implementation

{ Konstruktory i metody }

function TComplex.Real() :Double;
begin
  Result:=Self.Re;
end;

function TComplex.Imag() :Double;
begin
  Result:=Self.Im;
end;

procedure TComplex.SetValue(Re,Im :Double);
begin
  Self.Re:=Re;
  Self.Im:=Im;
end;

procedure TComplex.SetValue(Value :TComplex);
begin
  Self.Re:=Value.Re;
  Self.Im:=Value.Im;
end;

constructor TComplex.Create(Re,Im :Double);
begin
  //inherited Create;
  Self.SetValue(Re,Im);
end;

constructor TComplex.Zero();
begin
  Self.SetValue(0,0);
end;

function TComplex.Norm() :Double;
begin
  Result:=Sqrt(Re*Re+Im*Im);
end;

procedure TComplex.Dodaj(Arg :TComplex);
begin
  Self.Re:=Self.Re+Arg.Real;
  Self.Im:=Self.Im+Arg.Imag;
end;

procedure TComplex.Odejmij(Arg :TComplex);
begin
  Self.Re:=Self.Re-Arg.Re;
  Self.Im:=Self.Im-Arg.Im;
end;

procedure TComplex.Pomnoz(Arg :TComplex);
var
  Re,Im :Double;
begin
  Re:=Self.Re*Arg.Re-Self.Im*Arg.Im;
  Im:=Self.Re*Arg.Im+Self.Im*Arg.Re;
  Self.Re:=Re;
  Self.Im:=Im;
end;

procedure TComplex.Pomnoz(Arg :Double);
begin
  Self.Re:=Self.Re*Arg;
  Self.Im:=Self.Im*Arg;
end;

{ Funkcje zewnetrzne }

function ComplexZero :TComplex;
begin
  Result:=TComplex.Zero();
end;

function Real(const z :TComplex) :Double;
begin
  Result:=z.Re;
end;

function Imag(const z :TComplex) :Double;
begin
  Result:=z.Im;
end;

function ComplexSuma(const arg1, arg2 :TComplex) :TComplex;
begin
  Result:=TComplex.Create(arg1.Re+arg2.Re,arg1.Im+arg2.Im);
end;

function ComplexRoznica(const arg1, arg2 :TComplex) :TComplex;
begin
  Result:=TComplex.Create(arg1.Re-arg2.Re,arg1.Im-arg2.Im);
end;

function ComplexIloczyn(const arg1, arg2 :TComplex) :TComplex;
begin
  Result:=TComplex.Create(arg1.Re*arg2.Re-arg1.Im*arg2.Im,arg1.Re*arg2.Im+arg1.Im*arg2.Re);
end;

function ComplexKwadrat(const z :TComplex) :TComplex;
begin
  Result:=ComplexIloczyn(z,z);
end;

function ComplexToStr(const z :TComplex) :String;
begin
  Result:='('+FloatToStr(z.Re)+','+FloatToStr(z.Im)+')';
end;

end.
