unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AppEvnts,
  //dodane
  ShellApi;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    ApplicationEvents1: TApplicationEvents;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    Button1: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG;
      var Handled: Boolean);
    procedure RadioButton6Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private declarations }
    procedure WndProc(var Message :TMessage); override;
  public
    { Public declarations }
  end;

const
  SE_INFO_OKNO :Integer = 100;
  SE_INFO_APLIKACJA :Integer = 101;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  uchwytOkna :String;
begin
  Self.Caption:='Unikalne';
  ListBox1.Items.Add('Tytu okna zmieniony na "Unikalne"');
  uchwytOkna:=IntToStr(Self.Handle);
  ListBox1.Items.Add('Uchwyt okna: '+uchwytOkna);
  Edit1.Text:=uchwytOkna;
  ListBox1.Items.Add('--------');

  CheckBox4.Checked:=true;
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
var
  nazwaPliku :array[0..MAX_PATH-1] of Char; //char nazwaPliku[MAX_PATH];
  uchwyt :THandle;
  liczbaPlikow,i :Integer;
begin
  if CheckBox3.Checked then
    if (Msg.message=WM_SYSCOMMAND) and (Msg.wParam=SC_SCREENSAVE) then
    begin
      ListBox1.Items.Add('Uruchomiono wygaszacz ekranu (kolejka komunikatw)');
      Windows.Beep(100,100); //jest jeszcze SysUtil.Beep bezparametrowe
    end;

  if RadioButton6.Checked then
  begin
    if Msg.message=WM_DROPFILES then
    begin
      uchwyt:=Msg.wParam;
      liczbaPlikow:=DragQueryFile(uchwyt,$FFFFFFFF,nil,0); //IntToHex

      ListBox1.Columns:=0;
      ListBox1.Items.Add('Przenoszenie plikw...');
      ListBox1.Items.Add('Upuszczone zostao '+IntToStr(liczbaPlikow)+' plikw');

      for i:=1 to liczbaPlikow do
      begin
        DragQueryFile(uchwyt,i,nazwaPliku,MAX_PATH);
        ListBox1.Items.Add('Nazwa pliku nr '+IntToStr(i)+': '+nazwaPliku);
      end;

      DragFinish(uchwyt);
      Handled:=true;
    end;
  end;

  if CheckBox1.Checked then
    if Msg.hwnd=ListBox1.Handle then ListBox1.Items.Add('Komunikat do ListBox1');

  if Msg.message=WM_MOVE then Windows.Beep(100,10); //nieskuteczne

  if RadioButton1.Checked then
  begin
    ListBox1.Items.Add(
      IntToStr(Msg.message)+' '+
      IntToStr(Msg.lParam)+' '+
      IntToStr(Msg.wParam));
  end;

  if RadioButton2.Checked then
  begin
    case Msg.message of
      WM_MOUSEMOVE :
        begin
          ListBox1.Items.Add('WM_MOUSEMOVE');
          Caption:='x='+IntToStr(LOWORD(Msg.lParam))+' y=' + IntToStr(HIWORD(Msg.lParam));
          if (Msg.wParam and MK_LBUTTON)=MK_LBUTTON then Caption:=Caption+', lewy';
          if (Msg.wParam and MK_RBUTTON)=MK_RBUTTON then Caption:=Caption+', prawy';
          if (Msg.wParam and MK_CONTROL)=MK_CONTROL then Caption:=Caption+', Ctrl';
          //Caption:=' '+IntToStr(Msg.wParam);
          end;
      WM_NCMOUSEMOVE:
        begin
          ListBox1.Items.Add('WM_NCMOUSEMOVE');
          Caption:='x='+IntToStr(LOWORD(Msg.lParam))+' y='+IntToStr(HIWORD(Msg.lParam));
          //Self.ClientToScreen()
        end;
    end;
  end;

  if RadioButton3.Checked then
  begin
    if Msg.message=WM_USER+1 then
      ListBox1.Items.Add('WM_USER+1 - kolejka komunikatw aplikacji');
  end;

  //sprawdzenie CheckBox4.Checked zbedne, bo gdy nie zaznaczony i tak usuwane sa pozycje z menu
  if (Msg.message=WM_SYSCOMMAND) and (Msg.wParam=SE_INFO_APLIKACJA) then
  begin
    ListBox1.Items.Add('Wybrana zostaa pozycja w menu aplikacji');
    ShowMessage('Aplikacja demonstrujca podstawowe techniki zwizane z komunikatami Windows (menu aplikacji)');
  end;
end;

procedure TForm1.WndProc(var Message :TMessage);
begin
  inherited WndProc(Message);

  if (CheckBox3<>nil) and (CheckBox3.Checked) then
    if (Message.Msg=WM_SYSCOMMAND) and (Message.WParam=SC_SCREENSAVE) then
    begin
      ListBox1.Items.Add('Uruchomiono wygaszacz ekranu (WndProc okna)');
      Windows.Beep(100,100);
    end;

  if (RadioButton3<>nil) and RadioButton3.Checked then
    if Message.Msg=WM_USER+1 then
      ListBox1.Items.Add('WM_USER+1 - WndProc okna');

  if (CheckBox2<>nil) and CheckBox2.Checked then
    if Message.Msg=WM_MOVE then Windows.Beep(1000,10);

  if (RadioButton5<>nil) and RadioButton5.Checked then
  begin
    if (ListBox1<>nil) and (ListBox1.Tag=0) then
      begin
        if (Message.Msg<>308) and (Message.Msg<>WM_SETCURSOR) then
          ListBox1.Items.Add(IntToStr(Message.Msg));
      end;
  end;

  //sprawdzenie CheckBox4.Checked zbedne, bo gdy nie zaznaczony i tak usuwane sa pozycje z menu
  if CheckBox4<>nil then
    if (Message.Msg=WM_SYSCOMMAND) and (Message.WParam=SE_INFO_OKNO) then
    begin
      ListBox1.Items.Add('Wybrana zostaa pozycja w menu okna');
      ShowMessage('Aplikacja demonstrujca podstawowe techniki zwizane z komunikatami Windows (menu okna)');
    end;

  case Message.Msg of
    WM_MOVE:
      begin
        if CheckBox2.Checked then
        begin
          Windows.Beep(500,10);
          FlashWindow(Application.Handle,true);
        end;
      end;
    WM_DEVICECHANGE:
      begin
        ListBox1.Items.Add('WM_DEVICECHANGE');
        Windows.Beep(100,100);

        case Message.WParam of
          $8000: ListBox1.Items.Add('Nosnik wlozony');
          $8004: ListBox1.Items.Add('Nosnik usuniety');
        end;
      end;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ListBox1.Tag:=1;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
ListBox1.Clear;
end;

procedure TForm1.RadioButton6Click(Sender: TObject);
begin
if RadioButton6.Checked then DragAcceptFiles(Self.Handle,true)
else DragAcceptFiles(Self.Handle,false);  //to nigdy si nie zdaza
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
  var uchwytOkna, uchwytAplikacji :THandle;
begin
  uchwytOkna:=Self.Handle;
  uchwytAplikacji:=Application.Handle;
  if CheckBox4.Checked then
  begin
    AppendMenu(GetSystemMenu(uchwytOkna,false),MF_SEPARATOR,0,nil);
    AppendMenu(GetSystemMenu(uchwytOkna,false),MF_STRING,SE_INFO_OKNO,'O...');

    AppendMenu(GetSystemMenu(uchwytAplikacji,false),MF_SEPARATOR,0,nil);
    AppendMenu(GetSystemMenu(uchwytAplikacji,false),MF_STRING,SE_INFO_APLIKACJA,'O...');
  end
  else
  begin
    GetSystemMenu(uchwytOkna,true);
    GetSystemMenu(uchwytAplikacji,true);
  end;
end;

end.
