/* wersja 1.05, (c) Jacek Matulewski 2003, 2005, 2008, 2010 */

#ifndef _CPP_COMPLEX
#define _CPP_COMPLEX

#include <iostream.h>

template <class T>
class complex
{
	private:

	public:
    	T re, im;
        //wartosci domyslne dla obu elementow pozwalaja tworzyc konstruktory domyslne inicjujace wlasnosci typu complex
        //ten konstruktor zalatwia od razu rzutowanie z typu T
		complex(T _re=0,T _im=0)
        {
			re=_re;
			im=_im;
		}
        /*
        complex(const complex& arg) //konstruktor copy
        {
            re=arg.re;
            im=arg.im;
        }
        */
};

//const complex<double> i=complex<double>(0,1);
//template <class T> complex<T> imaginary_unit() {return complex<class T>(0,1);}

/* OPERATORY */
template <class T> complex<T> operator -(const complex<T>& arg)
{
    return complex<T>(-arg.re,-arg.im);
}

template <class T> complex<T> operator +(const complex<T>& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1.re+arg2.re,arg1.im+arg2.im);
}

template <class T> complex<T> operator -(const complex<T>& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1.re-arg2.re,arg1.im-arg2.im);
}

template <class T> complex<T> operator *(const complex<T>& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1.re*arg2.re-arg1.im*arg2.im,arg1.re*arg2.im+arg1.im*arg2.re);
}

template <class T> complex<T> operator /(const complex<T>& arg1,const complex<T>& arg2)
{
    T mian=arg2.re*arg2.re+arg2.im*arg2.im;
    T _re=(arg1.re*arg2.re+arg1.im*arg2.im)/mian;
    T _im=(arg1.im*arg2.re-arg1.re*arg2.im)/mian;
    return complex<T>(_re,_im);
}

template <class T> inline bool operator== (const complex<T>& arg1, const complex<T>& arg2)
{
    return ((arg1.re==arg2.re) && (arg1.im==arg2.im));
}

template <class T> inline bool operator!= (const complex<T>& arg1, const complex<T>& arg2)
{
    return ((arg1.re!=arg2.re) || (arg1.im!=arg2.im));
}

template <class T> ostream& operator << (ostream& s,const complex<T> c) //Przeciazenie operatora << (ofstream,fcomplex)
{
    s << "(" << real(c) << "," << imag(c) << ")";
    return s;
}

/* OPERATORY Z MIESZANYMI ARGUMENTAMI */
template <class T> complex<T> operator +(const complex<T>& arg1,const T& arg2)
{
    return complex<T>(arg1.re+arg2,arg1.im);
}

template <class T> complex<T> operator +(const T& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1+arg2.re,arg2.im);
}

template <class T> complex<T> operator -(const complex<T>& arg1,const T& arg2)
{
    return complex<T>(arg1.re-arg2,arg1.im);
}

template <class T> complex<T> operator -(const T& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1-arg2.re,-arg2.im);
}

template <class T> complex<T> operator *(const complex<T>& arg1,const T& arg2)
{
    return complex<T>(arg1.re*arg2,arg1.im*arg2);
}

template <class T> complex<T> operator *(const T& arg1,const complex<T>& arg2)
{
    return complex<T>(arg1*arg2.re,arg1*arg2.im);
}

template <class T> complex<T> operator /(const complex<T>& arg1,const T& arg2)
{
    //if (arg2==0) errormsg("Dzielenie przez zero",true);
    return complex<T>(arg1.re/arg2,arg1.im/arg2);
}

/* OPERATORY DODANE W LUTYM 2008 */
//w zasadzie powinny byc zdefiniowane jako operatory skladowe szablonu Complex
//uzywajac metody zwiekszajacej wartosc bierzacego obiektu - wtedy zamiast dwoch, tylko jedna operacja
template <class T> void operator +=(complex<T>& arg1,const complex<T>& arg2)
{
    arg1=arg1+arg2;
}

template <class T> void operator +=(complex<T>& arg1,const T& arg2)
{
    arg1=arg1+arg2;
}

template <class T> void operator *=(complex<T>& arg1,const T& arg2)
{
    arg1=arg1*arg2;
}

template <class T> void operator /=(complex<T>& arg1,const T& arg2)
{
    arg1=arg1/arg2;
}


/* FUNKCJE */
template <class T> T real(complex<T> arg) {return arg.re;}
template <class T> T imag(complex<T> arg) {return arg.im;}
template <class T> T norm(complex<T> arg) {return arg.re*arg.re+arg.im*arg.im;}
template <class T> T arg (complex<T> arg)
{
    //zmieniam zakres z -Pi:Pi na 0:2Pi
    ftyp phi=atan2(arg.im,arg.re);
    if (phi<0) phi+=2*M_PI;
    return phi;
}
template <class T> complex<T> conj(complex<T> arg) {return complex<T>(arg.re,-arg.im);}
template <class T> complex<T> exp(complex<T> arg) {return exp(arg.re)*complex<T>(cos(arg.im),sin(arg.im));}

//funkcje trygonometryczne przez rozklad na exp

#endif /* _CPP_COMPLEX */
