//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

//#include <math.h>

//wlasna implementacja liczb complex
//#include "_complex.cpp"
//typedef complex<double> fcomplex;

//implementacja complex z Standard C++ Library
#include <complex.h>
typedef std::complex<double> fcomplex;

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
    randomize();
    zbiorMandelbrotLubJulia=random(100)>50;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormPaint(TObject *Sender)
{
    /*
    //Dywan
    this->Caption="Dywan";

    int r,g,b;
    float x,y;
    TColor Kolor;
    for(x=0;x<ClientWidth;x++)
    for(y=0;y<ClientHeight;y++)
    {
        r=255*sin((x-y)/100.0);
        g=255*cos((x+y)/100.0);
        b=0;
        Kolor=(TColor)RGB(r,g,b);
        Canvas->Pixels[x][y]=Kolor;
    }
    */

    //*
    //Mandelbrot/Julia z wlasnymi complex
    //Mandelbrot/Julia z std::complex (Standard C++ Library)
    if (zbiorMandelbrotLubJulia) this->Caption="Zbir Mandelbrota";
    else this->Caption="Zbir Julii";

    TCursor kursor=this->Cursor;
    this->Cursor=crHourGlass;

	//zakres domyslny
	fcomplex min(-2.2,-1.2); //min,max - zakres badanej plaszczyzny zespolonej
	fcomplex max(1.2,1.2);
    //zakres: spirala w zbiorze Mandelbrota
	//fcomplex min(0.2016,0.541); //min,max - zakres badanej plaszczyzny zespolonej
	//fcomplex max(0.2175,0.5521);

    int w=this->ClientWidth;
    int h=this->ClientHeight;

    for (int x=0;x<w;x++) //x,y - wspolrzedne pikseli
	    for (int y=0;y<h;y++)
		{
		    fcomplex z,c;
			if (zbiorMandelbrotLubJulia)
			{
			    //Mandelbrot
                c=min+fcomplex(x*(real(max)-real(min))/w,y*(imag(max)-imag(min))/h);
				z=0;
            }
            else
			{
			    //Julia
                z=min+fcomplex(x*(real(max)-real(min))/w,y*(imag(max)-imag(min))/h);
				c=fcomplex(0.25,0.55);
            }

			byte indeks=0;
			for(;indeks<255;indeks++)
			{
			    z=z*z+c;
				if (norm(z)>=4) break;
            }
            //Canvas->Pixels[x][y]=(indeks==255)?clBlack:clWhite;
            Canvas->Pixels[x][y]=(indeks==255)?clBlack:(TColor)RGB(255-indeks,255-indeks,255-indeks);
        }

    this->Cursor=kursor;
    //*/
}
//---------------------------------------------------------------------------
