//---------------------------------------------------------------------------

#ifndef MediaPlayerH
#define MediaPlayerH
//---------------------------------------------------------------------------

#include <windows.h>
#include <system.hpp>
#include <mmsystem.h>

typedef enum {smpNiezainicjowany=-1, smpZatrzymany=0, smpOdtwarzanie=1, smpPauza=2} StanMediaPlayer;

class MediaPlayer
{
    private:
        HWND uchwytUkrytegoOkna;
        AnsiString sciezkaPliku;
        StanMediaPlayer stan;

        static LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
        HWND StworzOkno();
        void UstawFormatCzasu(); //milisekundy

    public:
        //funkcje zwrotne (prosty odpowiednik zdarzen)
        void (*Powiadomienie)(WPARAM wParam, LPARAM lParam);
        void (*KoniecOdtwarzania)();

        AnsiString SciezkaPliku();
        StanMediaPlayer Stan();
        AnsiString OpisStanu();

        MediaPlayer(AnsiString sciezkaPliku="",bool odtwarzaj=false);
        void Wczytaj(AnsiString sciezkaPliku);
        void Zamknij();
        void OdtwarzajBezPowiadamiania();
        void Odtwarzaj();
        void OdtwarzajSynchronicznie();
        void Pauza();
        void UstawPozycje(int pozycja);
        void Stop();
        void OdtwarzajOdPozycji(int pozycja);
        int Dlugosc();
        void UstawGlosnosc(int vol);
        int Pozycja();
};


#endif

