#include "MediaPlayer.h"

#include <Dialogs.hpp>

MediaPlayer* mediaPlayer = NULL; //tylko do uzytku w static WndProc, alternatywa: funkcja zaprzyjazniona

LRESULT CALLBACK MediaPlayer::WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
            switch(msg)
            {
                case WM_CLOSE:
                    DestroyWindow(hwnd);
                    break;
                case WM_DESTROY:
                    PostQuitMessage(0);
                    break;
                case MM_MCINOTIFY:
                    //ShowMessage("MM_MCINOTIFY");
                    //Beep(100,100);
                    if(mediaPlayer!=NULL)
                    {
                        if(mediaPlayer->Powiadomienie!=NULL) mediaPlayer->Powiadomienie(wParam,lParam);

                        switch(wParam)
                        {
                            case MCI_NOTIFY_SUCCESSFUL:
                                //ShowMessage("MCI_NOTIFY_SUCCESSFUL");
                                mediaPlayer->Stop();
                                if(mediaPlayer->KoniecOdtwarzania!=NULL) mediaPlayer->KoniecOdtwarzania();
                                break;
                            case MCI_NOTIFY_ABORTED:
                                //ShowMessage("MCI_NOTIFY_ABORTED");
                                break;
                            case MCI_NOTIFY_SUPERSEDED:
                                //ShowMessage("MCI_NOTIFY_SUPERSEDED");
                                break;
                            case MCI_NOTIFY_FAILURE:
                                //ShowMessage("MCI_NOTIFY_FAILURE");
                                ShowMessage("Bd odtwarzania");
                                break;
                            default: ShowMessage("Nieroznoznane powiadomienie"); break;
                        }
                    }
                    break;
                default:
                    return DefWindowProc(hwnd, msg, wParam, lParam);
            }
            return 0;
        }

        HWND MediaPlayer::StworzOkno()
        {
            //Wzor: http://www.winprog.org/tutorial/simple_window.html
            HANDLE hInstance = Application->Handle;

            const char nazwaKlasyOkna[]="KlasaOkna_MediaPlayer";

            //Rejestrowanie klasy okna
            WNDCLASSEX wc;
            wc.cbSize = sizeof(WNDCLASSEX);
            wc.style = 0;
            wc.lpfnWndProc = WndProc;
            wc.cbClsExtra = 0;
            wc.cbWndExtra = 0;
            wc.hInstance = hInstance;
            wc.hIcon = LoadIcon(NULL,IDI_APPLICATION);
            wc.hCursor = LoadCursor(NULL,IDC_ARROW);
            wc.hbrBackground = (HBRUSH)(COLOR_WINDOW); //clBtnFace
            wc.lpszMenuName = NULL;
            wc.lpszClassName = nazwaKlasyOkna;
            wc.hIconSm = LoadIcon(NULL,IDI_APPLICATION);

            if(!RegisterClassEx(&wc))
            {
                MessageBox(NULL,"Rejestracja klasy okna nie powioda si!","Bd MediaPlayer",MB_ICONEXCLAMATION | MB_OK);
                return NULL;
            }

            //Tworzenie okna
            HWND uchwytOkna = CreateWindowEx(
                WS_EX_LEFT, //zwykle okno
                nazwaKlasyOkna,
                "Ukryty adresat komunikatow",
                WS_OVERLAPPEDWINDOW, //zwykle okno
                //CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, //domyslne rozmiary
                100,100,800,100,
                NULL, NULL, hInstance, NULL);

            if(uchwytOkna==NULL)
            {
                MessageBox(NULL,"Stworzenie okna nie powiodlo si!","Bd MediaPlayer",MB_ICONEXCLAMATION | MB_OK);
                return NULL;
            }

            //Debug
            //ShowWindow(uchwytOkna, SW_SHOWNORMAL);
            //UpdateWindow(uchwytOkna);

            return uchwytOkna;
        }

        void MediaPlayer::UstawFormatCzasu() //milisekundy
        {
                AnsiString polecenie = "set " + sciezkaPliku + " time format milliseconds";
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

        AnsiString MediaPlayer::SciezkaPliku()
        {
                return sciezkaPliku;
        }

        StanMediaPlayer MediaPlayer::Stan()
        {
                return stan;
        }

        AnsiString MediaPlayer::OpisStanu()
        {
                AnsiString wynik="";
                switch(stan)
                {
                        case smpNiezainicjowany: wynik="Niezainicjowany"; break;
                        case smpZatrzymany: wynik="Zatrzymany"; break;
                        case smpOdtwarzanie: wynik="Odtwarzanie"; break;
                        case smpPauza: wynik="Pauza"; break;
                        default: wynik="Bd!"; break;
                }
                return wynik;
        }

        MediaPlayer::MediaPlayer(AnsiString sciezkaPliku,bool odtwarzaj)
                :stan(smpNiezainicjowany),uchwytUkrytegoOkna(NULL),
                 Powiadomienie(NULL),KoniecOdtwarzania(NULL)
        {
                uchwytUkrytegoOkna=StworzOkno(); //to moze sie nie powiesc, wowczas powiadamianie nie zadziala
                mediaPlayer=this;

                if(!sciezkaPliku.IsEmpty())
                {
                        Wczytaj(sciezkaPliku);
                        if(odtwarzaj)
                        {
                                Odtwarzaj();
                        }
                }
        }

        void MediaPlayer::Wczytaj(AnsiString sciezkaPliku)
        {
                this->sciezkaPliku="\""+sciezkaPliku+"\""; //dodanie cudzyslowow
                AnsiString polecenie = "open " + this->sciezkaPliku + " type mpegvideo";
                mciSendString(polecenie.c_str(),NULL,0,0);
                UstawFormatCzasu();
                stan=smpZatrzymany;
        }

        void MediaPlayer::Zamknij()
        {
                AnsiString polecenie = "close " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpNiezainicjowany;
        }

        void MediaPlayer::OdtwarzajBezPowiadamiania()
        {
                AnsiString polecenie = "play " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpOdtwarzanie;
        }

        void MediaPlayer::Odtwarzaj()
        {
                AnsiString polecenie = "play " + sciezkaPliku + " notify";
                mciSendString(polecenie.c_str(),NULL,0,uchwytUkrytegoOkna);
                stan=smpOdtwarzanie;
        }

        void MediaPlayer::OdtwarzajSynchronicznie()
        {
                AnsiString polecenie = "play " + sciezkaPliku + " wait";
                mciSendString(polecenie.c_str(),NULL,0,uchwytUkrytegoOkna);
                stan=smpOdtwarzanie;
        }

        void MediaPlayer::Pauza()
        {
                AnsiString polecenie = "stop " + sciezkaPliku;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpPauza;
        }

        void MediaPlayer::UstawPozycje(int pozycja)
        {
                AnsiString polecenie = "seek " + sciezkaPliku + " to " + pozycja;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpOdtwarzanie;
        }

        void MediaPlayer::Stop()
        {
            Pauza();
            UstawPozycje(0);
            stan=smpZatrzymany;
        }

        void MediaPlayer::OdtwarzajOdPozycji(int pozycja)
        {
                AnsiString polecenie = "play " + sciezkaPliku + " from " + pozycja;
                mciSendString(polecenie.c_str(),NULL,0,0);
                stan=smpOdtwarzanie;
        }

        int MediaPlayer::Dlugosc()
        {
                char sdlg[128];
                AnsiString polecenie = "status " + sciezkaPliku + " length";
                mciSendString(polecenie.c_str(),sdlg,128,0);
                int dlg=atoi(sdlg);
                return dlg;
        }

        void MediaPlayer::UstawGlosnosc(int vol)
        {
                AnsiString polecenie="setaudio "+ sciezkaPliku + " volume to " + vol;
                mciSendString(polecenie.c_str(),NULL,0,0);
        }

        int MediaPlayer::Pozycja()
        {
                char spoz[128];
                AnsiString polecenie = "status " + sciezkaPliku + " position";
                mciSendString(polecenie.c_str(),spoz,128,0);
                int poz=atoi(spoz);
                return poz;
        }

