//---------------------------------------------------------------------------

#pragma hdrstop

#include "Unit2.h"
#include "ProcessUserName.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

void ZbierzDaneOkna(HWND hWnd,DaneOkna* pDaneOkna,bool czyOknoGlowne,DaneOkna* pDaneOknaNadrzednego)
{
    pDaneOkna->uchwyt=hWnd;
    GetWindowText(hWnd,pDaneOkna->tytul,rozmiarLancucha);
    GetClassName(hWnd,pDaneOkna->nazwaKlasy,rozmiarLancucha);
    GetWindowRect(hWnd,&(pDaneOkna->polozenie));
    pDaneOkna->czyOknoGlowne=czyOknoGlowne;
    if(czyOknoGlowne)
    {
        unsigned long pid; GetWindowThreadProcessId(hWnd,&pid);
        GetProcessUserName(pDaneOkna->loginWlascicielaProcesu,rozmiarLancucha,pid);
        pDaneOkna->uchwytOknaNadrzednego=NULL;
    }
    else //przy podoknach przejmuje po prostu wlasciciela okna glownego
    {
        strcpy(pDaneOkna->loginWlascicielaProcesu,pDaneOknaNadrzednego->loginWlascicielaProcesu);
        pDaneOkna->uchwytOknaNadrzednego=pDaneOknaNadrzednego->uchwyt;
    }
}

bool CALLBACK EnumPodokna(HWND hWnd, LParam_EnumPodokna* lParam)
{
    DaneOkna* pDaneOkna=new DaneOkna; //przy deklaracji DaneOkna daneOkna obiekt znikalby po zakonczeniu metody
    DaneOkna* pDaneOknaNadrzednego=(DaneOkna*)lParam->wezel->Data;
    ZbierzDaneOkna(hWnd,pDaneOkna,false,pDaneOknaNadrzednego);

    AnsiString opisWezla;
    if(lParam->elementyOpisu.uchwyt) opisWezla+="["+(AnsiString)(int)hWnd+"] ";
    if(lParam->elementyOpisu.tytulOkna) opisWezla+=(AnsiString)pDaneOkna->tytul+" ";
    if(lParam->elementyOpisu.nazwaKlasyOkna) opisWezla+="("+(AnsiString)pDaneOkna->nazwaKlasy+")";
    opisWezla=opisWezla.Trim();
    //lParam->treeViewItems->AddChild(lParam->wezel,opisWezla);
    lParam->treeViewItems->AddChildObject(lParam->wezel,opisWezla,pDaneOkna);
    return true;
}

bool CALLBACK EnumWindowsProc(HWND hWnd, LParam_EnumWindowProc* lParam)
{
    if(lParam->tylkoWidoczneOkna && !IsWindowVisible(hWnd)) return true;

    DaneOkna* pDaneOkna=new DaneOkna; //przy deklaracji DaneOkna daneOkna obiekt znikalby po zakonczeniu metody
    ZbierzDaneOkna(hWnd,pDaneOkna,true,NULL);

    if(lParam->tylkoOknaBiezacegoUzytkownika && strcmp(pDaneOkna->loginWlascicielaProcesu,lParam->loginBiezacegoUzytkownika)!=0) return false;

    //etykieta wezla
    AnsiString opisWezla;
    if(lParam->elementyOpisu.uchwyt) opisWezla+="["+(AnsiString)(int)hWnd+"] ";
    if(lParam->elementyOpisu.tytulOkna) opisWezla+=(AnsiString)pDaneOkna->tytul+" ";
    if(lParam->elementyOpisu.nazwaKlasyOkna) opisWezla+="("+(AnsiString)pDaneOkna->nazwaKlasy+") ";
    if(lParam->elementyOpisu.wlascicielProcesu) opisWezla+=(AnsiString)"{"+pDaneOkna->loginWlascicielaProcesu+"}";
    opisWezla=opisWezla.Trim();

    //dodawanie wezla
    //TTreeNode* wezel = lParam->treeViewItems->Add(lParam->treeViewItems->GetFirstNode(),opisWezla);
    TTreeNode* wezel=lParam->treeViewItems->AddObject(lParam->treeViewItems->GetFirstNode(),opisWezla,pDaneOkna);

    //podokna
    LParam_EnumPodokna lParam_Podokno;
    lParam_Podokno.elementyOpisu = lParam->elementyOpisu;
    lParam_Podokno.treeViewItems = lParam->treeViewItems;
    lParam_Podokno.wezel = wezel;
    if(!lParam->tylkoGlowneOkna) EnumChildWindows(hWnd,(WNDENUMPROC)EnumPodokna,(LPARAM)&lParam_Podokno);
    return true;
}

