//---------------------------------------------------------------------------

#ifndef LinkLabelH
#define LinkLabelH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
//---------------------------------------------------------------------------

class TLinkLabel : public TCustomLabel
{
private:
        static const TColor KolorAktywny=clBlack;
        static const TColor KolorNieaktywny=clNavy;
protected:
        AnsiString FAdres;
        virtual void __fastcall SprawdzAdres(AnsiString AAdres) = 0;
        void __fastcall ZmienKolor(TObject *Sender,TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall PrzywrocKolor(TObject *Sender,TMouseButton Button, TShiftState Shift, int X, int Y);
public:
        __property AnsiString Adres = {read=FAdres, write=SprawdzAdres, nodefault};
        __fastcall TLinkLabel(TComponent* Owner);
        void __fastcall Polacz(TObject* Sender);
__published:
        __property Align;
        __property Enabled;
        __property Font;
        __property Transparent;
        __property Visible;
};

//---------------------------------------------------------------------------

class PACKAGE TMailLabel : public TLinkLabel
{
private:
        void __fastcall SprawdzAdres(AnsiString AAdres);
public:
        __fastcall TMailLabel(TComponent* Owner);
};

//---------------------------------------------------------------------------

class PACKAGE TWWWLinkLabel : public TLinkLabel
{
private:
        void __fastcall SprawdzAdres(AnsiString AAdres);
public:
        __fastcall TWWWLinkLabel(TComponent* Owner);
};

//---------------------------------------------------------------------------
#endif
