//---------------------------------------------------------------------------

#ifndef UruchamianieAplikacjiH
#define UruchamianieAplikacjiH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Classes.hpp>
//---------------------------------------------------------------------------

enum TPriorities {prIdle=IDLE_PRIORITY_CLASS,
				  prBelowNormal=BELOW_NORMAL_PRIORITY_CLASS,
				  prNormal=NORMAL_PRIORITY_CLASS,
				  prAboveNormal=ABOVE_NORMAL_PRIORITY_CLASS,
				  prHigh=HIGH_PRIORITY_CLASS,
				  prRealtime=REALTIME_PRIORITY_CLASS};
//Podobny do TWindowState, ale dodany swHide i wartosci odpowiadaja staym z WinAPI
enum TWindowStyles {swNormal=SW_NORMAL,
					swHide=SW_HIDE,
					swMaximize=SW_MAXIMIZE,
					swMinimize=SW_MINIMIZE};

class PACKAGE TCreateProcess : public TComponent
{
public:
private:
	AnsiString FFileName;
	AnsiString FDirectory;
	bool FDefaultPosition;
	bool FDefaultSize;
protected:
	TPriorities FPriority;
	int FLeft,FTop,FWidth,FHeight;
	TWindowStyles FWindowStyle;
	TProcessInformation FProcessInformation;
public:
	__fastcall TCreateProcess(TComponent* Owner);
	bool __fastcall Execute();
	bool __fastcall ExecuteAndWait();
	__property TProcessInformation ProcessInformation={read=FProcessInformation};
__published:
	__property AnsiString FileName={read=FFileName,write=FFileName};
	__property TPriorities Priority={read=FPriority,write=FPriority,default=prNormal};
	__property AnsiString Directory={read=FDirectory,write=FDirectory};
	__property int Left={read=FLeft,write=FLeft};
	__property int Top={read=FTop,write=FTop};
	__property int Width={read=FWidth,write=FWidth};
	__property int Height={read=FHeight,write=FHeight};
	__property bool DefaultPosition={read=FDefaultPosition,write=FDefaultPosition,default=true};
	__property bool DefaultSize={read=FDefaultSize,write=FDefaultSize,default=true};
	__property TWindowStyles WindowStyle={read=FWindowStyle,write=FWindowStyle,default=swNormal};
};
//---------------------------------------------------------------------------
#endif
