//---------------------------------------------------------------------------

#include <vcl.h>

#pragma hdrstop

#include "UruchamianieAplikacji.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TCreateProcess *)
{
	new TCreateProcess(NULL);
}
//---------------------------------------------------------------------------
__fastcall TCreateProcess::TCreateProcess(TComponent* Owner)
	: TComponent(Owner)
{
	FileName="";
	Priority=prNormal;
	Directory="";
	Left=0;
	Top=0;
	Width=500;
	Height=100;
	DefaultPosition=True;
	DefaultSize=True;
	WindowStyle=swNormal;
	memset(&ProcessInformation,0,sizeof(ProcessInformation));
}
//---------------------------------------------------------------------------
namespace Uruchamianieaplikacji
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TCreateProcess)};
		RegisterComponents("JM", classes, 0);
	}
}
//---------------------------------------------------------------------------

bool __fastcall TCreateProcess::Execute()
{
	if (FFileName=="") return false;

	char* PFileName=FFileName.c_str();
	char* PDirectory=FDirectory.c_str();
	if (Directory=="") PDirectory=NULL;

	//Inicjowanie struktury zawierajacej parametry uruchomienia aplikacji
	STARTUPINFO StartupInfo;
	memset(&StartupInfo,0,sizeof(StartupInfo));
	StartupInfo.cb=sizeof(TStartupInfo);
	StartupInfo.lpDesktop=NULL; //desktop z aplikacji, ktora uruchamia
	StartupInfo.lpTitle=NULL; //tytul okna konsoli, jezeli taka jest tworzona
	StartupInfo.dwX=FLeft;
	StartupInfo.dwY=FTop;
	StartupInfo.dwXSize=FWidth;
	StartupInfo.dwYSize=FHeight;

	int Flags=STARTF_USESHOWWINDOW;
	if (!FDefaultPosition) Flags=(Flags | STARTF_USEPOSITION);
	if (!FDefaultSize) Flags=(Flags | STARTF_USESIZE);
	StartupInfo.dwFlags=Flags;
	StartupInfo.wShowWindow=FWindowStyle;

	//Tworzenie i zerowanie struktury do ktorej zapisane beda informacje o procesie
	TProcessInformation LProcessInformation;
	memset(&LProcessInformation,0,sizeof(TProcessInformation));

	//Uruchamianie procesu
	bool Wynik=CreateProcess(
		NULL, //plik exe aplikacji
		PFileName, //polecenie uruchamiajace program
		NULL, //korzystamy z domyslnego opisu bezpieczenstwa procesu
		NULL, //korzystamy z domyslnego opisu bezpieczenstwa watku
		false, //czy uchwyty dziedziczone w procesie
		FPriority, //priorytet
		NULL, //korzystanie ze zmiennych srodowiska aplikacji wywolujacej
		PDirectory, //katalog biezacy aplikacji
		&StartupInfo, //parametry uruchomienia aplikacji
		&LProcessInformation //informacje o uruchomionej aplikacji
		);

	FProcessInformation=LProcessInformation;
	return Wynik;
}

bool __fastcall TCreateProcess::ExecuteAndWait()
{
	bool Wynik=Execute(); //uruchamia proces
	if (!Wynik) return false;
	WaitForSingleObject(ProcessInformation.hProcess,INFINITE); //czeka na zakonczenie
	memset(&FProcessInformation,0,sizeof(TProcessInformation)); //czysci ProcessInformation
	return Wynik;
}
