//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

#include <winsock.h>

#include <wininet.h>
#pragma comment(lib,"c:\Program Files\Borland\CBuilder6\Lib\Psdk\wininet.lib")

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
    WSADATA wsaData;
	WSAStartup(MAKEWORD(1,0),&wsaData);
	Button3Click(NULL);

    unsigned long typPolaczen=0;
    bool wynik=InternetGetConnectedState(&typPolaczen,0);
    bool polaczenieLAN=typPolaczen & INTERNET_CONNECTION_LAN;
    bool polaczenieModem=typPolaczen & INTERNET_CONNECTION_MODEM;
    bool polaczenieTrybOffline=typPolaczen & INTERNET_CONNECTION_OFFLINE;
    bool polaczenieProxy=typPolaczen & INTERNET_CONNECTION_PROXY;
    bool polaczenieRAS=typPolaczen & INTERNET_RAS_INSTALLED;

    Label1->Caption=(AnsiString)"Poczenie aktywne: "+(wynik?"tak":"nie");
    AnsiString polaczenia="Poczenia ("+IntToStr(typPolaczen)+"): ";
    if(polaczenieLAN) polaczenia+="LAN; ";
    if(polaczenieModem) polaczenia+="modem; ";
    if(polaczenieTrybOffline) polaczenia+="offline; ";
    if(polaczenieProxy) polaczenia+="proxy; ";
    if(polaczenieRAS) polaczenia+="RAS; ";
    Label2->Caption=polaczenia;
}
//---------------------------------------------------------------------------

#include <urlmon.h>
#pragma comment(lib,"c:\Program Files\Borland\CBuilder6\Lib\Psdk\urlmon.lib")

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    char temp[MAX_PATH];
    GetTempPath(MAX_PATH,temp);
    AnsiString nazwaPliku=(AnsiString)temp+"\\torun1.bmp";
    //ShowMessage(nazwaPliku);
    if(URLDownloadToFile(
        NULL,
        "http://www.fizyka.umk.pl/~jacek/img/torun.bmp",
        nazwaPliku.c_str(),
        0,
        NULL)==S_OK)
    {
        Image1->Picture->LoadFromFile(nazwaPliku);
        ShowMessage("Plik pobrany");
    }
    else ShowMessage("Bd podczas pobierania pliku");
}
//---------------------------------------------------------------------------

#include <winsock.h>

AnsiString AdresIP(AnsiString& nazwaKomputera,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze
	hostent* pInfoKomputer=gethostbyname(nazwaKomputera.c_str());
	nazwaKomputera=(AnsiString)(pInfoKomputer->h_name);
	//Konwertujemy adres IP protokou IPv4 na acuch z kropkami
	in_addr* pAdres=(in_addr*)(*(pInfoKomputer->h_addr_list));
	AnsiString Wynik=(AnsiString)inet_ntoa(*pAdres);

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return Wynik;
}

AnsiString NazwaDNS(AnsiString adresIP,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze
	unsigned long dwAdresIP=inet_addr(adresIP.c_str());
	hostent* pInfoKomputer=gethostbyaddr((char*)&dwAdresIP,sizeof(unsigned long),AF_INET);
	AnsiString Wynik="";
	if (pInfoKomputer!=NULL) Wynik=StrPas(pInfoKomputer->h_name);
	else ShowMessage("Pobranie nazwy komputera nie powiodo si");

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return Wynik;
}
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
        WSACleanup();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
        if (Edit1->Text.IsEmpty()) return;
	char pierwszyZnak=Edit1->Text.c_str()[0];
	if (pierwszyZnak>='0' && pierwszyZnak<='9') //adres IP czy nazwa DNS
	{
		Edit2->Text=NazwaDNS(Edit1->Text,false,false);
        Label9->Caption="Nazwa DNS:";
	}
	else
	{
		AnsiString nazwaKomputera=Edit1->Text; //aby przekazac TCaption do AdresIP
		Edit2->Text=AdresIP(nazwaKomputera,false,false);
		Edit1->Text=nazwaKomputera;
        Label9->Caption="Adres IP:";
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
    //Pobieramy nazw lokalnego komputera
	char nazwaKomputera[MAX_COMPUTERNAME_LENGTH];
	unsigned long dlugoscNazwyKomputera;
	GetComputerName(nazwaKomputera,&dlugoscNazwyKomputera);
	Edit1->Text=nazwaKomputera;

	//Pobieramy IP lokalnego komputera
	Button2Click(NULL);
}
//---------------------------------------------------------------------------
