//---------------------------------------------------------------------------

#include <windows.h>

//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------

void WyswietlKomunikat(char* s)
{
    MessageBox(NULL,s,"Komunikat z biblioteki DLL",MB_OK);
}

void __export Test0();
__declspec(dllexport) void Test1();
extern "C" __export void Test2();
void FunkcjaWewnetrzna();
extern "C" __export int __stdcall Test3a(char* s);
extern "C" __declspec(dllexport) char* __stdcall Test3b(char* s); //z "__export" nie jest eksportowana
extern "C" __export int __stdcall Test3c(int i);

#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
//BOOL WINAPI DllMain(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
    switch(reason)
    {
        case DLL_PROCESS_ATTACH:
            WyswietlKomunikat("DllMain - Zaladowane do procesu procesu");
            break;
        case DLL_PROCESS_DETACH:
            WyswietlKomunikat("DllMain - Wyladowane z pamieci procesu");
            break;
        case DLL_THREAD_ATTACH:
            WyswietlKomunikat("DllMain - Zaladowane do pamieci watku");
            break;
        case DLL_THREAD_DETACH:
            WyswietlKomunikat("DllMain - Zaladowane z pamieci watku");
            break;
        default:
            WyswietlKomunikat("Inny powod wywolania DllMain");
            break;
    }

    return 1;
}

void Test0()
{
    WyswietlKomunikat("DLL - Test0");
}

void Test1()
{
    WyswietlKomunikat("DLL - Test1");
}

void Test2()
{
    WyswietlKomunikat("DLL - Test2");
    FunkcjaWewnetrzna();
}

void FunkcjaWewnetrzna()
{
    WyswietlKomunikat("DLL - Funkcja wewnetrzna");
}

int __stdcall Test3a(char* s)
{
    WyswietlKomunikat(s);
    return strlen(s);
}

char* __stdcall Test3b(char* s)
{
    WyswietlKomunikat(s);
    return s;
}

int __stdcall Test3c(int i)
{
    char bufor[10];
    WyswietlKomunikat(itoa(i,bufor,10));
    return i;
}


//---------------------------------------------------------------------------

