//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
//#include <Dialogs.hpp>
#pragma hdrstop
//---------------------------------------------------------------------------
//   Important note about DLL memory management when your DLL uses the
//   static version of the RunTime Library:
//
//   If your DLL exports any functions that pass String objects (or structs/
//   classes containing nested Strings) as parameter or function results,
//   you will need to add the library MEMMGR.LIB to both the DLL project and
//   any other projects that use the DLL.  You will also need to use MEMMGR.LIB
//   if any other projects which use the DLL will be performing new or delete
//   operations on any non-TObject-derived classes which are exported from the
//   DLL. Adding MEMMGR.LIB to your project will change the DLL and its calling
//   EXE's to use the BORLNDMM.DLL as their memory manager.  In these cases,
//   the file BORLNDMM.DLL should be deployed along with your DLL.
//
//   To avoid using BORLNDMM.DLL, pass string information using "char *" or
//   ShortString parameters.
//
//   If your DLL uses the dynamic version of the RTL, you do not need to
//   explicitly add MEMMGR.LIB as this will be done implicitly for you
//---------------------------------------------------------------------------

void MyShowMessage(AnsiString s)
{
    MessageBox(NULL,s.c_str(),"Biblioteka DLL",MB_OK);
}
void MyShowMessage(char* s)
{
    MessageBox(NULL,s,"Biblioteka DLL",MB_OK);
}

void __export Test0();
__declspec(dllexport) void Test1();
extern "C" __export void __stdcall Test2();
void FunkcjaWewnetrzna();
extern "C" __export int __stdcall Test3a(AnsiString s);
extern "C" __export AnsiString __stdcall Test3b(AnsiString s);
extern "C" __export int __stdcall Test3c(int i);


#pragma argsused
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fwdreason, LPVOID lpvReserved)
{
        switch(fwdreason)
        {
                case DLL_PROCESS_ATTACH:
                        MyShowMessage("DLL: DllMain, Biblioteka zaadowana do pamici procesu");
                        break;
                case DLL_PROCESS_DETACH:
                        MyShowMessage("DLL: DllMain, Biblioteka wyadowana z pamici procesu");
                        break;
                default:
                        MyShowMessage("DLL: DllMain, Inny powd");
                        break;
        }
        return 1;
}

void Test0()
{
        MyShowMessage("DLL: Test0");
}

void Test1()
{
        MyShowMessage("DLL: Test1");
}

void __stdcall Test2()
{
        MyShowMessage("DLL: Test2");
        FunkcjaWewnetrzna();
}

void FunkcjaWewnetrzna()
{
        MyShowMessage("DLL: FunkcjaWewnetrzna");
}

int __stdcall Test3a(AnsiString s)
{
        MyShowMessage("DLL: Test3a (funkcja pobierajca argument i zwracajca wartosc)");
        int dlg=s.Length();
        MyShowMessage("DLL: Test3a, Argument: "+s+", dugosc: "+IntToStr(dlg));
        return dlg;
}

AnsiString __stdcall Test3b(AnsiString s)
{
        MyShowMessage("DLL: Test3b (funkcja pobierajca argument i zwracajca wartosc)");
        int dlg=s.Length();
        MyShowMessage("DLL: Test3b, Argument: "+s+", dugosc: "+IntToStr(dlg));
        return s;
}


int __stdcall Test3c(int i)
{
        MyShowMessage("DLL: Test3c (funkcja pobierajca argument i zwracajca wartosc)");
        MyShowMessage("DLL: Test3c, Argument: "+IntToStr(i));
        return i;
}


//---------------------------------------------------------------------------

