//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <windows.h>
#include <mmsystem.h>

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "trayicon"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
    Image1->Width=Image1->Picture->Width;
    Image1->Height=Image1->Picture->Height;
    ClientWidth=Image1->Width;
    ClientHeight=Image1->Height;

    czyPrzenoszone=false;

    odtwarzanieWPetli=true;
    sciezkaPliku=ExtractFilePath(Application->ExeName)+(AnsiString)"Muzyka.mp3";
    //sciezkaPliku="C:\\WINDOWS\\MEDIA\\notify.wav"; //Testy

    TSearchRec sr;
    if(FindFirst(sciezkaPliku,faAnyFile,sr)!=0)
    {
        int wynik=MessageBox(NULL,((AnsiString)"Brak pliku "+sciezkaPliku+"!\nCzy mog go pobra z sieci?").c_str(),"Choinka 2010",MB_YESNOCANCEL | MB_ICONQUESTION);
        switch(wynik)
        {
            case IDYES: PobierzPlik("http://www.fizyka.umk.pl/~jacek/dydaktyka/winprog/projekty/Choinka.mp3",sciezkaPliku); break;
            case IDNO: Muzyka1->Checked=false; Muzyka1->Enabled=false; break;
            case IDCANCEL: exit(0); break;
        }
    }
    else FindClose(sr);

    sciezkaPliku="\""+sciezkaPliku+"\""; //dodanie cudzyslowow
    if(Muzyka1->Checked) UruchomOdtwarzanieMuzyki();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Image1MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if(Button==mbLeft)
    {
        x0=X;
        y0=Y;
        czyPrzenoszone=true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Image1MouseMove(TObject *Sender, TShiftState Shift,
      int X, int Y)
{
    if(czyPrzenoszone)
    {
        int dx=X-x0;
        int dy=Y-y0;
        Left+=dx;
        Top+=dy;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Image1MouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
    czyPrzenoszone=false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Zakocz1Click(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Ukryj1Click(TObject *Sender)
{
    this->Visible=!this->Visible;
    Ukryj1->Caption=this->Visible?"Ukryj":"Przywr";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
    switch(Key)
    {
        case char(27): Zakocz1Click(NULL); break;
        case ' ': Ukryj1Click(NULL); break;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrayIcon1Restore(TObject *Sender)
{
    //podwojne klikniecie
    Ukryj1Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
    ShowWindow(Application->Handle,SW_HIDE);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrayIcon1MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    //if(Button==mbRight) PopupMenu1->Popup(X,Y);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::O1Click(TObject *Sender)
{
    ShowMessage("Choinka 2010\nJacek Matulewski\ne-mail: jacek@fizyka.umk.pl");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrayIcon1Click(TObject *Sender)
{
    /*
    TNotifyIconData dane=TrayIcon1->GetNotifyIconData();
    strcpy(dane.szInfoTitle,"Choinka 2010");
    strcpy(dane.szInfo,"Wesoych wit!");
    dane.uFlags=dane.uFlags | NIF_INFO;
    TrayIcon1->SetNotifyIconData(dane);
    */
    TrayIcon1->ShowBalloonInfo("Choinka 2010","Wesoych wit!");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Zyczenia1Click(TObject *Sender)
{
    TrayIcon1Click(NULL);
}
//---------------------------------------------------------------------------

#include <urlmon.h>
#pragma comment(lib,"c:\Program Files\Borland\CBuilder6\Lib\Psdk\urlmon.lib")

void TForm1::PobierzPlik(AnsiString adresPliku,AnsiString nazwaPliku)
{
    if(URLDownloadToFile(
        NULL,
        adresPliku.c_str(),
        nazwaPliku.c_str(),
        0,
        NULL)==S_OK) ShowMessage("Plik pobrany");
    else ShowMessage("Bd podczas pobierania pliku");
}

void TForm1::UruchomOdtwarzanieMuzyki(bool odPoczatku)
{
    static bool inicjacja=true;
    //ShowMessage(sciezkaPliku);
    //PlaySound(sciezkaPliku,NULL,SND_ASYNC | SND_FILENAME | SND_LOOP); //tylko WAV

    if(inicjacja)
    {
        AnsiString polecenie = "open " + sciezkaPliku + " type mpegvideo";
        mciSendString(polecenie.c_str(),NULL,0,0);
        inicjacja=false;
    }

    AnsiString polecenie = "play " + sciezkaPliku;
    if(odPoczatku) polecenie+=" from 0";
    if(odtwarzanieWPetli) polecenie+=" notify";
    //ShowMessage(polecenie);
    mciSendString(polecenie.c_str(),NULL,0,this->Handle);
}

void TForm1::ZatrzymajOdtwarzanieMuzyki(bool zamknacPlik)
{
    AnsiString polecenie = "stop " + sciezkaPliku;
    mciSendString(polecenie.c_str(),NULL,0,0);
    if(zamknacPlik)
    {
        polecenie = "close " + sciezkaPliku;
        mciSendString(polecenie.c_str(),NULL,0,0);
    }
}

void __fastcall TForm1::WndProc(TMessage &Message)
{
    TForm::WndProc(Message);

    if(Message.Msg==MM_MCINOTIFY && Message.WParam==MCI_NOTIFY_SUCCESSFUL)
        UruchomOdtwarzanieMuzyki(true);
}
void __fastcall TForm1::Muzyka1Click(TObject *Sender)
{
    if(Muzyka1->Checked) ZatrzymajOdtwarzanieMuzyki();
    else UruchomOdtwarzanieMuzyki();
    Muzyka1->Checked=!Muzyka1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    ZatrzymajOdtwarzanieMuzyki(true);

    AlphaBlend=true;
    for(;AlphaBlendValue>0;AlphaBlendValue--) Sleep(1);
}
//---------------------------------------------------------------------------

