//---------------------------------------------------------------------------

#ifndef RejestrH
#define RejestrH

#include <Forms.hpp>
#include <Registry.hpp>
#include <Dialogs.hpp>
#include <SysUtils.hpp>

//Zapamietywanie polozenia i rozmiaru okna
bool CzytajUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty);
bool ZapiszUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty);
bool UsunUstawieniaOkna(AnsiString klucz);

//Automatyczne uruchamianie aplikacji
bool CzyIstniejeZapisAutostart(AnsiString nazwa,HKEY kluczGlowny);
bool ZapiszAutostart(AnsiString nazwa,HKEY kluczGlowny,AnsiString plikEXE);
bool UsunAutostart(AnsiString nazwa,HKEY kluczGlowny);

//Dodaj/Usun programy
struct TDodajUsunInfo
{
  AnsiString
	DisplayName, DisplayIcon, DisplayVersion,
	Contact, Publisher, Comments, URLUpdateInfo,
	URLInfoAbout, InstallLocation, InstallSource,
	ProductID, UninstallString, UninstallPath,
	ModifyPath, Readme, HelpLink, HelpTelephone,
	RegCompany, RegOwner, LogFile;
  int
	VersionMajor, VersionMinor, NoRemove, NoRepair,
	Language;
};

bool CzyIstniejeZapisDodajUsun(AnsiString nazwaKlucza);
bool ZapiszDodajUsun(AnsiString nazwaKlucza,TDodajUsunInfo rekord);
bool UsunDodajUsun(AnsiString nazwaKlucza);

//Katalogi uytkownika
AnsiString PobierzSciezkeDoKataloguSpecjalnego(AnsiString wartosc);
AnsiString PobierzSciezkeDoMojeDokumenty();

//Pozycja w menu kontekstowym pliku
void RozszerzMenuKontekstoweIstniejacegoTypuPliku(AnsiString rozszerzenie,AnsiString polecenie,AnsiString opis);

//---------------------------------------------------------------------------
#endif
