//---------------------------------------------------------------------------


#pragma hdrstop

#include "Rejestr.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

//---------------------------------------------------------------------------
//Zapamietywanie polozenia i rozmiaru okna

bool CzytajUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty)
{
	bool Wynik=false;
	TRegistry* Rejestr=new TRegistry();
	Rejestr->Access=KEY_READ;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	if (Rejestr->KeyExists(klucz))
	{
		if (Rejestr->OpenKey(klucz,false))
		{
			if (Rejestr->ValueExists("Left")) okno->Left=Rejestr->ReadInteger("Left");
			if (Rejestr->ValueExists("Top")) okno->Top=Rejestr->ReadInteger("Top");
			if (Rejestr->ValueExists("Width")) okno->Width=Rejestr->ReadInteger("Width");
			if (Rejestr->ValueExists("Height")) okno->Height=Rejestr->ReadInteger("Height");
			Rejestr->CloseKey();
			Wynik=true;
		}
		else
		{
			if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie moe by otwarty.");
		}
	}
	else if (komunikaty) ShowMessage("Klucz \""+klucz+"\" nie istnieje.");
	delete Rejestr;
	return Wynik;
}

bool ZapiszUstawieniaOkna(TForm* okno,AnsiString klucz,bool komunikaty)
{
	bool Wynik=false;
	TRegistry* Rejestr=new TRegistry();
	Rejestr->Access=KEY_WRITE;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	if (!Rejestr->KeyExists(klucz))
		if (!Rejestr->CreateKey(klucz))
		{
			ShowMessage("Klucz \""+klucz+"\" nie moe by utworzony.");
			delete Rejestr;
			return false;
		}

	if (Rejestr->OpenKey(klucz,false))
	{
		Rejestr->WriteInteger("Left",okno->Left);
		Rejestr->WriteInteger("Top",okno->Top);
		Rejestr->WriteInteger("Width",okno->Width);
		Rejestr->WriteInteger("Height",okno->Height);
		Rejestr->CloseKey();
		Wynik=true;
	}
	else ShowMessage("Klucz \""+klucz+"\" nie moe by otwarty.");

	delete Rejestr;
	return Wynik;
}

bool UsunUstawieniaOkna(AnsiString klucz)
{
	bool Wynik=false;
	TRegistry* Rejestr=new TRegistry();
	Rejestr->Access=KEY_WRITE;
	Rejestr->RootKey=HKEY_CURRENT_USER;

	if(Rejestr->KeyExists(klucz))
        Wynik=Rejestr->DeleteKey(klucz);

    //usuwam rowniez klucz-rodzic jezeli jest pusty
    AnsiString nadklucz=klucz.SubString(0,klucz.LastDelimiter("\\"));
    //ShowMessage(nadklucz);
    bool czyPusty=true;
    if(Rejestr->KeyExists(nadklucz))
    {
        if(Rejestr->OpenKey(nadklucz,false))
        {
            //if(Rejestr->HasSubKeys()) czyPusty=false;
            TRegKeyInfo opisKlucza;
            Rejestr->GetKeyInfo(opisKlucza);
            if(opisKlucza.NumSubKeys>0 || opisKlucza.NumValues>0) czyPusty=false;
            Rejestr->CloseKey();
        }
        Rejestr->DeleteKey(nadklucz);
    }

	delete Rejestr;
	return Wynik;
}

//---------------------------------------------------------------------------
//Automatyczne uruchamianie aplikacji

enum TAutostartCzynnosci {acSprawdz=0,acZapisz=1,acUsun=2};

bool KonfigurujAutostart(AnsiString nazwa,HKEY kluczGlowny,AnsiString plikEXE,TAutostartCzynnosci czynnosc)
{
	const AnsiString klucz="\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
	bool Wynik=false;
	TRegistry* Rejestr=new TRegistry();
	Rejestr->Access=KEY_SET_VALUE;
	if (czynnosc==acSprawdz) Rejestr->Access=KEY_QUERY_VALUE;
	Rejestr->RootKey=kluczGlowny;

	if (Rejestr->OpenKey(klucz,false))
	{
		switch (czynnosc)
		{
			case acSprawdz: Wynik=Rejestr->ValueExists(nazwa); break;
			case acZapisz:  Rejestr->WriteString(nazwa,plikEXE); break;
			case acUsun:    Rejestr->DeleteValue(nazwa); break;
		}
		Rejestr->CloseKey();
		if (czynnosc!=acSprawdz) Wynik=true;
	}
	else ShowMessage("Klucz \""+klucz+"\" nie istnieje lub nie moe by otwarty.");

	delete Rejestr;
	return Wynik;
}

bool CzyIstniejeZapisAutostart(AnsiString nazwa,HKEY kluczGlowny)
{
	return KonfigurujAutostart(nazwa,kluczGlowny,"",acSprawdz);
}

bool ZapiszAutostart(AnsiString nazwa,HKEY kluczGlowny,AnsiString plikEXE)
{
	return KonfigurujAutostart(nazwa,kluczGlowny,plikEXE,acZapisz);
}

bool UsunAutostart(AnsiString nazwa,HKEY kluczGlowny)
{
	return KonfigurujAutostart(nazwa,kluczGlowny,"",acUsun);
}

//---------------------------------------------------------------------------
//Dodaj/Usun programy

enum TDodajUsunCzynnosci {ducSprawdz=0,ducZapisz=1,ducUsun=2};

bool KonfigurujDodajUsun(AnsiString nazwaKlucza,TDodajUsunInfo rekord,TDodajUsunCzynnosci czynnosc)
{
	const AnsiString Klucz="\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	bool Wynik=false;

	TRegistry* Rejestr=new TRegistry();
	Rejestr->Access=KEY_ALL_ACCESS;
	Rejestr->RootKey=HKEY_LOCAL_MACHINE;

	if (Rejestr->KeyExists(Klucz)) //klucz Uninstall
	{
		AnsiString KluczAplikacji=Klucz+'\\'+nazwaKlucza;
		bool KluczAplikacjiIstnieje=Rejestr->KeyExists(KluczAplikacji);
		if (czynnosc==ducSprawdz)
		{
			delete Rejestr;
			return KluczAplikacjiIstnieje;;
		}

		if (KluczAplikacjiIstnieje)
		{
			switch (czynnosc)
			{
				case ducSprawdz:
					delete Rejestr;
					return KluczAplikacjiIstnieje;
					//break;
				case ducZapisz:
					delete Rejestr;
					return false;
					//break;
				case ducUsun:
					Wynik=Rejestr->DeleteKey(KluczAplikacji);
					delete Rejestr;
					return Wynik;
					//break;
			}
		}
		else
			if (czynnosc==ducUsun)
			{
				delete Rejestr;
				return false;
			}

		if (Rejestr->OpenKey(KluczAplikacji,true))
		{
			if (rekord.DisplayName!="") Rejestr->WriteString("DisplayName",rekord.DisplayName);
			else
			{
				delete Rejestr;
				throw Exception("Pole \"DisplayName\" musi zawiera nazw aplikacji.");
			}
			if (rekord.UninstallString!="") Rejestr->WriteString("UninstallString",rekord.UninstallString);
			else
			{
				delete Rejestr;
				throw Exception("Pole \"UninstallString\" musi zawiera ciek do pliku instalatora.");
			}
			if (rekord.DisplayIcon!="") Rejestr->WriteString("DisplayIcon",rekord.DisplayIcon);
			if (rekord.DisplayVersion!="") Rejestr->WriteString("DisplayVersion",rekord.DisplayVersion);
			if (rekord.Contact!="") Rejestr->WriteString("Contact",rekord.Contact);
			if (rekord.Publisher!="") Rejestr->WriteString("Publisher",rekord.Publisher);
			if (rekord.Comments!="") Rejestr->WriteString("Comments",rekord.Comments);
			if (rekord.URLUpdateInfo!="") Rejestr->WriteString("URLUpdateInfo",rekord.URLUpdateInfo);
			if (rekord.URLInfoAbout!="") Rejestr->WriteString("URLInfoAbout",rekord.URLInfoAbout);
			if (rekord.InstallLocation!="") Rejestr->WriteString("InstallLocation",rekord.InstallLocation);
			if (rekord.InstallSource!="") Rejestr->WriteString("InstallSource",rekord.InstallSource);
			if (rekord.ProductID!="") Rejestr->WriteString("ProductID",rekord.ProductID);
			if (rekord.UninstallPath!="") Rejestr->WriteString("UninstallPath",rekord.UninstallPath);
			if (rekord.ModifyPath!="") Rejestr->WriteString("ModifyPath",rekord.ModifyPath);
			if (rekord.Readme!="") Rejestr->WriteString("Readme",rekord.Readme);
			if (rekord.HelpLink!="") Rejestr->WriteString("HelpLink",rekord.HelpLink);
			if (rekord.HelpTelephone!="") Rejestr->WriteString("HelpTelephone",rekord.HelpTelephone);
			if (rekord.RegCompany!="") Rejestr->WriteString("RegCompany",rekord.RegCompany);
			if (rekord.RegOwner!="") Rejestr->WriteString("RegOwner",rekord.RegOwner);
			if (rekord.LogFile!="") Rejestr->WriteString("LogFile",rekord.LogFile);
			if (rekord.VersionMajor!=-1) Rejestr->WriteInteger("VersionMajor",rekord.VersionMajor);
			if (rekord.VersionMinor!=-1) Rejestr->WriteInteger("VersionMinor",rekord.VersionMinor);
			if (rekord.NoRemove!=-1) Rejestr->WriteInteger("NoRemove",rekord.NoRemove);
			if (rekord.NoRepair!=-1) Rejestr->WriteInteger("NoRepair",rekord.NoRepair);
			if (rekord.Language!=-1) Rejestr->WriteInteger("Language",rekord.Language);
			Rejestr->CloseKey();
			Wynik=true;
		}
		else
		{
			delete Rejestr;
			throw Exception("Klucz informacji o instalacji nie moe by stworzony lub otwarty.");
		}
	}
  delete Rejestr;
  return Wynik;
}

bool CzyIstniejeZapisDodajUsun(AnsiString nazwaKlucza)
{
	TDodajUsunInfo rekord;
	return KonfigurujDodajUsun(nazwaKlucza,rekord,ducSprawdz);
}

bool ZapiszDodajUsun(AnsiString nazwaKlucza,TDodajUsunInfo rekord)
{
	return KonfigurujDodajUsun(nazwaKlucza,rekord,ducZapisz);
}

bool UsunDodajUsun(AnsiString nazwaKlucza)
{
	TDodajUsunInfo rekord;
	return KonfigurujDodajUsun(nazwaKlucza,rekord,ducUsun);
}

//---------------------------------------------------------------------------
//Katalogi uytkownika

AnsiString PobierzSciezkeDoKataloguSpecjalnego(AnsiString wartosc)
{
	const AnsiString Klucz="\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
	AnsiString Wynik="";
	TRegistry* Rejestr=new TRegistry();

	Rejestr->Access=KEY_READ;
	Rejestr->RootKey=HKEY_CURRENT_USER;
	if (Rejestr->OpenKey(Klucz,false))
	{
		if (Rejestr->ValueExists(wartosc))
			Wynik=Rejestr->ReadString(wartosc);
		else
		{
			delete Rejestr;
			throw Exception("Wartosc "+wartosc+" nie istnieje");
		}
		Rejestr->CloseKey();
	}
	else
	{
		delete Rejestr;
		throw Exception("Klucz \""+Klucz+"\" nie istnieje lub nie moe by otwarty.");
	}
	delete Rejestr;
	return Wynik;
}

AnsiString PobierzSciezkeDoMojeDokumenty()
{
	return PobierzSciezkeDoKataloguSpecjalnego("Personal");
}

//---------------------------------------------------------------------------
//Pozycja w menu kontekstowym pliku

void RozszerzMenuKontekstoweIstniejacegoTypuPliku(AnsiString rozszerzenie,AnsiString polecenie,AnsiString opis)
{
	TRegistry* Rejestr=new TRegistry();
	Rejestr->RootKey=HKEY_CLASSES_ROOT;

	AnsiString NazwaTypu;

	//Odczytywanie nazwy typu
	if (Rejestr->OpenKey("\\."+rozszerzenie,false))
	{
		NazwaTypu=Rejestr->ReadString("");
		Rejestr->CloseKey();
	}
	else
	{
		delete Rejestr;
		throw Exception("Rozszerzenie \""+rozszerzenie+"\" nie jest zarejestrowane");
	}

	//Czy polecenie jest juz zdefiniowane
	AnsiString Klucz="\\"+NazwaTypu+"\\shell\\"+polecenie;
	if (Rejestr->KeyExists(Klucz))
	{
		delete Rejestr;
		throw Exception("Polecenie \""+polecenie+"\" jest ju zdefiniowane dla rozszerzenia \"."+rozszerzenie+"\"");
	}

	//Tworzenie klucza dla polecenia
	if (Rejestr->OpenKey(Klucz,true))
	{
		Rejestr->WriteString("",opis);
		Rejestr->CloseKey();

		if (Rejestr->OpenKey(Klucz+"\\Command",true))
		{
			Rejestr->WriteString("","\""+Application->ExeName+"\" \"%1\"");
			Rejestr->CloseKey();
		}
		else
		{
			delete Rejestr;
			throw Exception("Utworzenie klucza "+Klucz+"\\Command nie jest moliwe");
		}

	}
	else
	{
		delete Rejestr;
		throw Exception("Utworzenie klucza "+Klucz+" nie jest moliwe");
	}
}

