﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;

using HWND = System.IntPtr;

namespace JacekMatulewski.PInvoke
{
    public static class WinAPI
    {
        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool MessageBeep(uint rodzajDzwieku);

        [DllImport("user32.dll", EntryPoint = "MessageBox", CharSet = CharSet.Unicode)]
        public static extern int _MessageBox(IntPtr hWnd, String text, String caption, uint type);

        public enum StanOkna : uint { Ukryte = 0, Normalme, Zminimalizowane, Zmaksymalizowane, Nieaktywne, Domyślne = 10 };

        [DllImport("kernel32.dll")]
        //public static extern uint WinExec(string polecenie, uint stanOkna);
        public static extern uint WinExec(string polecenie, StanOkna stanOkna);

        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx(
            string katalog,
            ref long wolneMiejsceDlaUzytkownika,
            ref long rozmiarDysku,
            ref long wolneMiejsceNaDysku);

        [DllImport("kernel32.dll")]
        public static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

        [DllImport("user32.dll")]
        public static extern bool GetCursorPos(ref Point lpPoint); //Cursor.Position

        [DllImport("user32.dll")]
        public static extern bool GetPhysicalCursorPos(ref Point lpPoint);

        [DllImport("user32.dll")]
        public static extern bool SetProcessDPIAware();

        [DllImport("gdi32.dll", CharSet = CharSet.Auto, SetLastError = true, ExactSpelling = true)]
        public static extern int BitBlt(IntPtr hDC, int x, int y, int nWidth, int nHeight, IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        /*
        [DllImport("user32.dll")]
        public static extern bool GetWindowRect(IntPtr hWnd, ref RECT rect);
        */

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left;        // x position of upper-left corner
            public int Top;         // y position of upper-left corner
            public int Right;       // x position of lower-right corner
            public int Bottom;      // y position of lower-right corner
        }

        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool GetWindowRect(IntPtr hwnd, out RECT lpRect);

        [DllImport("user32.dll")]
        public static extern bool PrintWindow(IntPtr hWnd, IntPtr hDC, int flags);

        [DllImport("user32.dll")]
        public static extern HWND GetDesktopWindow();


        public delegate bool EnumWindowsProc(HWND hWnd, int lParam);

        [DllImport("USER32.DLL")]
        public static extern bool EnumWindows(EnumWindowsProc enumFunc, IntPtr lParam);

        [DllImport("USER32.DLL")]
        public static extern int GetWindowText(HWND hWnd, StringBuilder lpString, int nMaxCount);

        [DllImport("USER32.DLL")]
        public static extern int GetWindowTextLength(HWND hWnd);

        [DllImport("USER32.DLL")]
        public static extern bool IsWindowVisible(HWND hWnd);

        [DllImport("USER32.DLL")]
        public static extern IntPtr GetShellWindow();

        [DllImport("user32")]
        //[return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool EnumChildWindows(IntPtr hwndParent, EnumWindowsProc lpEnumFunc, IntPtr lParam);

        [DllImport("user32.dll")]
        public static extern HWND FindWindow(string nazwaKlasy, string nazwaOkna);

        public const int WM_CLOSE = 0x0010;
        public const int WM_SYSCOMMAND = 0x0112;
        public const int WM_NCMOUSEMOVE = 0x00A0;
        public const int SC_SCREENSAVE = 0xF140;

        [DllImport("user32.dll")]
        public static extern int SendMessage(HWND hwnd, uint Msg, int wParam, int lParam);

    }
}
