using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;

namespace PInvoke
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            string katalogGlownyDysku = System.Environment.GetLogicalDrives()[0]; //"C:\\"
            int procentZajetosci = wolneMiejsceNaDysku(katalogGlownyDysku);
            if (procentZajetosci >= 0) progressBar1.Value = procentZajetosci;
        }

        #region MessageBox
        [DllImport("User32.dll")]
        static extern bool MessageBeep(uint rodzajDzwieku);

        private void button1_Click(object sender, EventArgs e)
        {
            MessageBeep(0);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            MessageBeep(48);
        }
        #endregion

        #region "WinExec"
        [DllImport("kernel32.dll")]
        static extern uint WinExec(string polecenie, uint stanOkna);

        enum StyleOkna : uint { Ukryte = 0, Normalme, Zminimalizowane, Zmaksymalizowane, Nieaktywne, Domyslne = 10 };
        
        private void button3_Click(object sender, EventArgs e)
        {
            uint wynik = WinExec(textBox1.Text, (uint)StyleOkna.Normalme);
            if (wynik <= 31)
                MessageBox.Show("Bd " + wynik + "! Nie udao si uruchomi " + textBox1.Text);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (System.IO.File.Exists(textBox1.Text))
                openFileDialog1.FileName = textBox1.Text;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                textBox1.Text = openFileDialog1.FileName;
        }
        #endregion

        #region GetDiskFreeSpaceEx
        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx(string katalog, ref long
           wolneMiejsceDlaUzytkownika, ref long rozmiarDysku, ref long
           wolneMiejsceNaDysku);

        private int wolneMiejsceNaDysku(string katalogGlownyDysku)
        {
            int wolneMiejsceNaDyskuProcenty;

            long wolneMiejsceDlaUzytkownika = 0;
            long rozmiarDysku = 0;
            long wolneMiejsceNaDysku = 0;
            if (GetDiskFreeSpaceEx(katalogGlownyDysku,
                  ref wolneMiejsceDlaUzytkownika,
                  ref rozmiarDysku,
                  ref wolneMiejsceNaDysku))
            {
                wolneMiejsceNaDyskuProcenty = (int)(100 * (rozmiarDysku - wolneMiejsceNaDysku) / (double)rozmiarDysku);
            }
            else
            {
                wolneMiejsceNaDyskuProcenty = -1;
                //throw new Exception("Nie udao si odczyta iloci wolnego miejsca na dysku");
            }
            return wolneMiejsceNaDyskuProcenty;
        }
        #endregion

        [DllImport("kernel32.dll")]
        static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

        [DllImport("kernel32.dll")]
        static extern uint GetSystemDirectory(StringBuilder bufor, uint rozmiarBufora);

        private void button5_Click(object sender, EventArgs e)
        {
            const int MAX_PATH = 260;
            StringBuilder katalogWindows = new StringBuilder(MAX_PATH);
            uint rozmiar = (uint)katalogWindows.Capacity;
            GetWindowsDirectory(katalogWindows, rozmiar);
            MessageBox.Show(katalogWindows.ToString());
        }

        private void button6_Click(object sender, EventArgs e)
        {
            const int MAX_PATH = 260;
            StringBuilder katalogWindows = new StringBuilder(MAX_PATH);
            uint rozmiar = (uint)katalogWindows.Capacity;
            GetSystemDirectory(katalogWindows, rozmiar);
            MessageBox.Show(katalogWindows.ToString());           
        }

        
    }
}