using System;
using System.Collections.Generic;
using System.Text;

namespace Para
{
    public class Para<T,C> : IComparable<Para<T,C>>
            where T : IComparable<T>
            where C : IComparable<C>
    {
        private T pierwszy = default(T);
        private C drugi = default(C);

        public Para(T pierwszy, C drugi)
        {
            this.pierwszy = pierwszy;
            this.drugi = drugi;
        }

        public override string ToString()
        {
            return pierwszy.ToString() + "\t" + drugi.ToString();
        }

        public int CompareTo(Para<T,C> innaPara)
        {
            int wartosc = pierwszy.CompareTo(innaPara.pierwszy);
            if (wartosc != 0) return wartosc;
            else return drugi.CompareTo(innaPara.drugi);
        }
    }        
}
