﻿Imports System.Xml.Linq

Public Class Form1

    Private Sub Form1_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        Dim dr As DialogResult = MessageBox.Show(
            "Czy napewno zamknąć okno?",
            "Ustawienia",
            MessageBoxButtons.YesNo,
            MessageBoxIcon.Question,
            MessageBoxDefaultButton.Button2)
        If dr = Windows.Forms.DialogResult.Yes Then
            Me.Text = "Okno zostanie zamknięte"
            e.Cancel = False
        Else
            Me.Text = "Okno nie zostało zamknięte"
            e.Cancel = True
        End If
    End Sub

    Dim nazwaPliku As String = "MojeUstawienia.xml"

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        'MessageBox.Show("Okno jest zamykane")

        Dim xml As XDocument = New XDocument(
            New XDeclaration("1.0", "utf-8", "yes"),
            New XElement("Ustawienia",
                    New XElement("Rozmiar",
                            New XElement("X", Me.Width),
                            New XElement("Y", Me.Height)
                            ),
                    New XElement("Położenie",
                            New XElement("X", Me.Left),
                            New XElement("Y", Me.Top)
                            )
                        )
                    )

        xml.Save(nazwaPliku)
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        'MessageBox.Show("Okno jest ładowane")

        Try
            Dim xml As XDocument = XDocument.Load(nazwaPliku)
            Me.Width = Integer.Parse(xml.Root.Element("Rozmiar").Element("X").Value)
            Me.Height = Integer.Parse(xml.Root.Element("Rozmiar").Element("Y").Value)
            Me.Left = Integer.Parse(xml.Root.Element("Położenie").Element("X").Value)
            Me.Top = Integer.Parse(xml.Root.Element("Położenie").Element("Y").Value)
        Catch exc As System.IO.FileNotFoundException
            MessageBox.Show(
                "Aplikacja uruchamiana po raz pierwszy",
                "Komunikat",
                MessageBoxButtons.OK,
                MessageBoxIcon.Information)
        Catch exc As Exception
            MessageBox.Show(
                "Nie udało się odczytać danych z pliku " & nazwaPliku & vbNewLine & "(" & exc.Message & ")",
                "Błąd przy odczytywaniu ustawień",
                MessageBoxButtons.OK,
                MessageBoxIcon.Error)
        End Try

        'Dim xml As XDocument = XDocument.Load(nazwaPliku)
        'Integer.TryParse(xml.Root.Element("Rozmiar").Element("X").Value, Me.Width)
        'Integer.TryParse(xml.Root.Element("Rozmiar").Element("Y").Value, Me.Height)
        'Integer.TryParse(xml.Root.Element("Położenie").Element("X").Value, Me.Left)
        'Integer.TryParse(xml.Root.Element("Położenie").Element("Y").Value, Me.Top)
    End Sub
End Class
