﻿using Microsoft.Maui.Controls;

namespace Zachowania
{
    //zachowanie modyfikujące wygląd lub działanie przycisku
    internal class PrzyciskZLicznikiem : Behavior<Button>
    {
        public uint Licznik { get; set; } = 0;

        protected override void OnAttachedTo(Button button)
        {
            base.OnAttachedTo(button);
            if(button != null)
            {
                button.BackgroundColor = Colors.Green;
                button.Text = Licznik.ToString();
                button.Clicked += button_Clicked;
            }
        }

        private void button_Clicked(object sender, EventArgs e)
        {
            Licznik++;

            Button button = sender as Button;
            button.BackgroundColor = Colors.Navy;
            button.Text = Licznik.ToString();
        }

        protected override void OnDetachingFrom(Button button)
        {
            button.Clicked -= button_Clicked;
            button.BackgroundColor = Colors.LightGrey;
            base.OnDetachingFrom(button);
        }
    }

    internal class PrzyciskZmieniającyKolor : Behavior<Button>
    {
        bool stan = false;

        public Color WłączonyKolor { get; set; } = Colors.Green;
        public Color WyłączonyKolor { get; set; } = Colors.Red;

        protected override void OnAttachedTo(Button button)
        {
            button.Clicked += Button_Clicked;
        }

        private void Button_Clicked(object sender, EventArgs e)
        {
            stan = !stan;
            Button button = sender as Button;
            button.BackgroundColor = stan ? WłączonyKolor : WyłączonyKolor;
            button.Text = stan ? "Włączony" : "Wyłączony";
        }
    }

    public static class Tło
    {
        private static void kolorZmieniony(BindableObject d, object poprzedniaWartość, object nowaWartość)
        {
            Color kolor = (Color)nowaWartość;
            Brush pędzel = new SolidColorBrush(kolor);
            if (d is VisualElement)
                (d as VisualElement).Background = pędzel;
        }

        public static readonly BindableProperty KolorProperty =
            BindableProperty.CreateAttached(
                "Kolor",
                typeof(Color),
                typeof(Tło),
                Colors.LightGrey,
                BindingMode.OneWay,
                null,
                kolorZmieniony);

        public static Color GetKolor(BindableObject d)
        {
            return (Color)d.GetValue(KolorProperty);
        }

        public static void SetKolor(BindableObject d, Color kolor)
        {
            d.SetValue(KolorProperty, kolor);
        }
    }
}
