﻿using RównaniaKwadratowe_Model;

namespace RównaniaKwadratowe_MAUI
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();
            Title = "Równania kwadrowe 2.0 (c) PSPiZK 2023";
        }

        private void Button_Clicked(object sender, EventArgs e)
        {
            string sa = edA.Text;
            string sb = edB.Text;
            string sc = edC.Text;

            try
            {
                double a = double.Parse(sa);
                double b = double.Parse(sb);
                double c = double.Parse(sc);

                RozwiązywaczRównańKwadratowych rrk = new RozwiązywaczRównańKwadratowych(a, b, c);
                if(rrk.CzyMaRozwiązania)
                {
                    lbX1.Text = rrk.X1.ToString();
                    lbX2.Text = rrk.X2.ToString();
                }
                else 
                {
                    lbX1.Text = "---";
                    lbX2.Text = "---";
                }
                lbX1.TextColor = Colors.Black;
                lbX2.TextColor = Colors.Black;
            }
            catch (Exception exc)
            {
                //await DisplayAlert(Title, "Błąd: " + exc.Message, "OK");
                lbX1.Text = "---";
                lbX2.Text = "---";
                lbX1.TextColor = Colors.Red;
                lbX2.TextColor = Colors.Red;
            }
        }

        private void ed_TextChanged(object sender, TextChangedEventArgs e)
        {
            Button_Clicked(sender, e);
        }
    }
}