﻿namespace CzujnikMAUI;

public partial class MainPage : ContentPage
{
	public MainPage()
	{
		InitializeComponent();
	}

	private void Switch_Toggled(object sender, ToggledEventArgs e)
	{
		if (OrientationSensor.Default.IsSupported)
		{
			if (!OrientationSensor.Default.IsMonitoring)
			{
				OrientationSensor.Default.ReadingChanged += OrientationSensor_ReadingChanged;
				OrientationSensor.Default.Start(SensorSpeed.UI);
			}
			else
			{
				OrientationSensor.Default.Stop();
				OrientationSensor.Default.ReadingChanged -= OrientationSensor_ReadingChanged;
			}
		}
		else lbOrientacja.Text = "Brak czujnika";
	}

	private void OrientationSensor_ReadingChanged(object sender, OrientationSensorChangedEventArgs e)
	{
		lbOrientacja.Text = e.Reading.ToString();
	}
}

