﻿using PierwszaAplikacjaMAUI.Model;
using System.Windows.Input;

namespace PierwszaAplikacjaMAUI.ModelWidoku
{
    internal class PolecenieResetowania : ICommand
    {
        private KolorMW kolor;

        public PolecenieResetowania(KolorMW kolor)
        {
            this.kolor = kolor;
            kolor.PropertyChanged += kolor_PropertyChanged;
        }

        private void kolor_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            if (CanExecuteChanged != null) CanExecuteChanged(this, EventArgs.Empty);
        }

        public event EventHandler CanExecuteChanged;

        public bool CanExecute(object parameter)
        {
            return kolor.R != 0 || kolor.G != 0 || kolor.B != 0;
        }

        public void Execute(object parameter)
        {
            kolor.R = 0;
            kolor.G = 0;
            kolor.B = 0;
        }
    }

    internal class PolecenieZapisz : ICommand
    {
        Model.Kolor model;

        public PolecenieZapisz(Model.Kolor model)
        {
            this.model = model;
        }


        public event EventHandler CanExecuteChanged;

        public bool CanExecute(object parameter)
        {
            return true;
        }

        public void Execute(object parameter)
        {            
            PlikXml.Zapisz(model);
        }
    }
}
