﻿using System.Reflection.Metadata;

namespace Foto;

public partial class MainPage : ContentPage
{
	public MainPage()
	{
		InitializeComponent();
	}

	private async void button_Clicked(object sender, EventArgs e)
	{
		FileResult wynik = await MediaPicker.Default.CapturePhotoAsync();
		if(wynik != null)
		{
			string ścieżkaPliku = Path.Combine(FileSystem.CacheDirectory, wynik.FileName);			
			label.Text = "Ścieżka pliku: " + ścieżkaPliku;
			using Stream strumień = await wynik.OpenReadAsync();
			await strumień.CopyToAsync(File.OpenWrite(ścieżkaPliku));
			image.Source = ImageSource.FromFile(ścieżkaPliku);
            label.TextColor = Colors.Black;
        }
		else
		{
			label.Text = "Nie udało się zrobić zdjęcia";
			label.TextColor = Colors.DarkRed;
		}	
	}
}

