﻿namespace PierwszaAplikacjaMAUI;

public partial class MainPage : ContentPage
{
	public MainPage()
	{
		InitializeComponent();
        var rgb = PlikXml.Czytaj();
        suwakR.Value = rgb.R;
        suwakG.Value = rgb.G;
        suwakB.Value = rgb.B;
    }

	//private int licznik = 0;

	private void slider_ValueChanged(object sender, ValueChangedEventArgs e)
	{
        //licznik++;
        //Title = licznik.ToString();
        //prostokąt.Background = new SolidColorBrush(Colors.Blue);
        /*
		Slider sliderSender = sender as Slider;
		Color kolor = Color.FromRgba(
			sliderSender.Value, 
			sliderSender.Value,
			sliderSender.Value, 
			1.0);        
		*/
        Color kolor = Color.FromRgba(
            suwakR.Value,
            suwakG.Value,
            suwakB.Value,
            1.0);
        //etykietaR.Text = kolor.Red.ToString();
        //etykietaG.Text = kolor.Green.ToString();
        //etykietaB.Text = kolor.Blue.ToString();
        byte r = (byte)(kolor.Red * 255);
        byte g = (byte)(kolor.Green * 255);
        byte b = (byte)(kolor.Blue * 255);
        etykietaR.Text = r.ToString();
        etykietaG.Text = g.ToString();
        etykietaB.Text = b.ToString();
        prostokąt.Background = new SolidColorBrush(kolor);
		Title = $"Kolor: {kolor.ToHex()}";
    }

    private void ContentPage_Disappearing(object sender, EventArgs e)
    {
        try
        {
            PlikXml.Zapisz(
                suwakR.Value,
                suwakG.Value,
                suwakB.Value);
        }
        catch (Exception exc)
        {
            Title = $"Błąd zapisu do pliku {exc.Message}";
        }
    }
}

