﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace ZadaniaMVVM.ModelWidoku
{
    public class Zadanie : ObservedObject
    {
        private Model.Zadanie model;

        #region Własności
        public string Opis
        {
            get
            {
                return model.Opis;
            }
        }

        public Model.PriorytetZadania Priorytet
        {
            get
            {
                return model.Priorytet;
            }
        }

        public DateTime DataUtworzenia
        {
            get
            {
                return model.DataUtworzenia;
            }
        }

        public DateTime PlanowanyTerminRealizacji
        {
            get
            {
                return model.PlanowanyTerminRealizacji;
            }
        }

        public bool CzyZrealizowane
        {
            get
            {
                return model.CzyZrealizowane;
            }
        }

        public bool CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie
        {
            get
            {
                return !CzyZrealizowane && (DateTime.Now > PlanowanyTerminRealizacji);
            }
        }
        #endregion

        public Zadanie(Model.Zadanie model)
        {
            this.model = model;
        }

        public Zadanie(string opis, DateTime dataUtworzenia, DateTime planowanyTerminRealizacji,
            Model.PriorytetZadania priorytet, bool czyZrealizowane)
        {
            model = new Model.Zadanie(opis, dataUtworzenia, planowanyTerminRealizacji, priorytet, czyZrealizowane);
        }

        public Model.Zadanie GetModel()
        {
            return model;
        }

        #region Polecenia
        private ICommand oznaczJakoZrealizowane;

        public ICommand OznaczJakoZrealizowane
        {
            get
            {
                if (oznaczJakoZrealizowane == null) oznaczJakoZrealizowane =
                         new RelayCommand(
                             o =>
                             {
                                 model.CzyZrealizowane = true;
                                 onPropertyChanged(nameof(CzyZrealizowane), nameof(CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie));
                             },
                             o =>
                             {
                                 return !model.CzyZrealizowane;
                             });
                return oznaczJakoZrealizowane;
            }
        }

        private ICommand oznaczJakoNiezrealizowane;

        public ICommand OznaczJakoNiezrealizowane
        {
            get
            {
                if (oznaczJakoNiezrealizowane == null) oznaczJakoNiezrealizowane =
                         new RelayCommand(
                             o =>
                             {
                                 model.CzyZrealizowane = false;
                                 onPropertyChanged(nameof(CzyZrealizowane), nameof(CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminie));
                             },
                             o =>
                             {
                                 return model.CzyZrealizowane;
                             });
                return oznaczJakoNiezrealizowane;
            }
        }
        #endregion

        public override string ToString()
        {
            return model.ToString();
        }
    }
}
