﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Threading;
using System.Windows.Threading;

namespace ZegarWPF.ModelWidoku
{
    public class Zegar : ObservedObject
    {
        private readonly bool isInDesignMode = DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject());

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
            }
        }

        private const int okresOdświeżaniaWidoku = 250;

        public Zegar()
        {
            DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
            timerOdświeżaniaWidoku.Tick += (sender, e) => { onPropertyChanged(nameof(AktualnyCzas)); };
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(okresOdświeżaniaWidoku);
            if(!isInDesignMode) timerOdświeżaniaWidoku.Start();
        }
    }
}
