﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace MojaPierwszaAplikacjaMVVM.ModelWidoku
{
    using Model;
    using System.CodeDom;
    using System.Windows.Automation;
    using System.Windows.Input;

    public class ModelWidokuMPAM : INotifyPropertyChanged
    {
        private ModelMPAM model = PlikHelper.Odczytaj();

        public double Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                onPropertyChanged(nameof(Wartość));
                //PlikHelper.Zapisz(model);
                model.Zapisz();
            }
        }

        private ICommand resetuj = null;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null) resetuj = new RelayCommand(
                    (object o) =>
                    {
                        model.Resetuj();
                        onPropertyChanged(nameof(Wartość));
                    },
                    (object o) =>
                    {
                        return model.Wartość > 0;
                    });
                return resetuj;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
