﻿namespace AsystentZakupówUWP.Model
{    
    public class Sumator
    {
        public decimal Suma { get; private set; } //własność tylko do odczytu
        public decimal Limit { get; private set; }

        public Sumator(decimal limit, decimal suma = 0)
        {
            this.Limit = limit;
            this.Suma = suma;
        }

        public bool Dodaj(decimal kwota)
        {
            if (!SprawdźKwotę(kwota)) return false;
            else
            {
                Suma += kwota;
                return true;
            }
        }

        public bool SprawdźKwotę(decimal kwota)
        {
            if (kwota <= 0) return false;
            if (Suma + kwota > Limit) return false;
            return true;
        }
    }
}
