﻿using System.IO;

namespace AsystentZakupówUWP.Model
{
    public static class DAL
    {
        private const string filePath = "Suma.txt";

        public static bool Zapisz(Sumator model)
        {
            try
            {
                File.WriteAllText(filePath, model.Suma.ToString());
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static Sumator Czytaj(decimal limit)
        {
            try
            {
                string s = File.ReadAllText(filePath);
                decimal suma = decimal.Parse(s);
                return new Sumator(limit, suma);
            }
            catch
            {
                return new Sumator(limit, 0);
            }
        }
    }
}
