﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Threading;

namespace WpfApp1.ModelWidoku
{
    public class Zegar : INotifyPropertyChanged
    {
        private DateTime poprzedniCzas = DateTime.Now;

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (AktualnyCzas - poprzedniCzas < TimeSpan.FromSeconds(1) &&
                AktualnyCzas.Second == poprzedniCzas.Second) return;

            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(
                    nameof(AktualnyCzas)));
        }

        private const int okresOdświeżaniaWidoku = 250;

        private readonly bool czyJestWTrybieProjektowania = DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject());

        public Zegar()
        {
            DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(okresOdświeżaniaWidoku);
            timerOdświeżaniaWidoku.Tick += (sender, e) => { onPropertyChanged(); };
            if (!czyJestWTrybieProjektowania) timerOdświeżaniaWidoku.Start();
        }
    }
}
