﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace GrafikaPerPixel
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private WriteableBitmap twórzRysunek(double width, double height)
        {
            if (double.IsNaN(width) || double.IsNaN(height) || width == 0 || height == 0)
                return null;

            WriteableBitmap wbmp = new WriteableBitmap((int)width, (int)height, 0, 0, PixelFormats.Bgr32, null);
            int bpp = (wbmp.Format.BitsPerPixel + 7) / 8;
            int rozmiarWiersza = wbmp.PixelWidth * bpp;
            int rozmiarTablicyKolorów = rozmiarWiersza * wbmp.PixelHeight;
            byte[] tablicaKolorów = new byte[rozmiarTablicyKolorów];

            //new Random().NextBytes(tablicaKolorów);            
            /*
            for(int i = 0; i < rozmiarTablicyKolorów; i+=4)
            {                
                tablicaKolorów[i] = 0; //B
                tablicaKolorów[i + 1] = 255; //G
                tablicaKolorów[i + 2] = 255; //R
                tablicaKolorów[i + 3] = 255; //A
            }
            */
            for (int ix = 0; ix < wbmp.PixelWidth; ix += 1)
                for (int iy = 0; iy < wbmp.PixelHeight; iy += 1)
                {
                    int i = (ix + iy * wbmp.PixelWidth) * bpp;
                    tablicaKolorów[i] = 0; //B
                    tablicaKolorów[i + 1] = (byte)(255.0 * (Math.Sin((ix + iy) / 10.0) + 1) / 2); //G
                    tablicaKolorów[i + 2] = (byte)(255.0 * (Math.Sin((ix - iy) / 10.0) + 1) / 2); //R
                    tablicaKolorów[i + 3] = 255; //A
                }

            Int32Rect rect = new Int32Rect(0, 0, wbmp.PixelWidth, wbmp.PixelHeight);
            wbmp.WritePixels(rect, tablicaKolorów, rozmiarWiersza, 0);
            return wbmp;
        }

        private void updateImage()
        {
            image.Source = twórzRysunek(clientArea.ActualWidth, clientArea.ActualHeight);
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            updateImage();
        }

        private void Window_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            updateImage();
        }
    }
}
