﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace ZabawaWPF
{
    public class ZmianaPołożeniaOknaZaDowolnyPunkt : Behavior<Window>
    {
        protected override void OnAttached()
        {
            base.OnAttached();
            AssociatedObject.MouseDown += Window_MouseDown;
            AssociatedObject.MouseMove += Window_MouseMove;
            AssociatedObject.MouseUp += Window_MouseUp;
            AssociatedObject.MouseLeave += Window_MouseLeave;
        }

        private bool czyTrwaPrzenoszenie = false;
        private Point punktPoczątkowy;
        private Cursor kursor;

        private void Window_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if (e.LeftButton == MouseButtonState.Pressed)
            {
                kursor = AssociatedObject.Cursor;
                AssociatedObject.Cursor = Cursors.Hand;
                czyTrwaPrzenoszenie = true;
                punktPoczątkowy = e.GetPosition(AssociatedObject);
            }
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                Vector przesunięcie = e.GetPosition(AssociatedObject) - punktPoczątkowy;
                AssociatedObject.Left += przesunięcie.X;
                AssociatedObject.Top += przesunięcie.Y;
            }
        }

        private void Window_MouseUp(object sender, MouseButtonEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
            {
                czyTrwaPrzenoszenie = false;
                AssociatedObject.Cursor = kursor;
            }
        }

        private void Window_MouseLeave(object sender, MouseEventArgs e)
        {
            if (czyTrwaPrzenoszenie)
                Window_MouseUp(sender, new MouseButtonEventArgs(e.MouseDevice, e.Timestamp, MouseButton.Left));
        }
    }
}
