﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ZabawaWPF
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        #region Przenoszenie za dowolny punkt
        private bool czyTrwaPrzenoszenie = false;
        private Point punktPoczątkowy;
        private Cursor kursor;

        private void Window_MouseDown(object sender, MouseButtonEventArgs e)
        {
            if(e.LeftButton == MouseButtonState.Pressed)
            {
                kursor = Cursor;
                Cursor = Cursors.Hand;
                czyTrwaPrzenoszenie = true;
                punktPoczątkowy = e.GetPosition(this);
            }
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            if(czyTrwaPrzenoszenie)
            {
                Vector przesunięcie = e.GetPosition(this) - punktPoczątkowy;
                Left += przesunięcie.X;
                Top += przesunięcie.Y;
            }
        }

        private void Window_MouseUp(object sender, MouseButtonEventArgs e)
        {
            if(czyTrwaPrzenoszenie)
            {
                czyTrwaPrzenoszenie = false;
                Cursor = kursor;
            }
        }

        private void Window_MouseLeave(object sender, MouseEventArgs e)
        {
            if(czyTrwaPrzenoszenie)
                Window_MouseUp(sender, new MouseButtonEventArgs(e.MouseDevice, e.Timestamp, MouseButton.Left));
        }
        #endregion

        private bool zakończonaAnimacjaZamykania = false;

        private void okno_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            if (!zakończonaAnimacjaZamykania)
            {
                (this.Resources["scenorys"] as Storyboard).Begin();
                e.Cancel = true;
            }
        }

        private void Storyboard_Completed(object sender, EventArgs e)
        {
            zakończonaAnimacjaZamykania = true;
            Close();
        }
    }
}
