﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;
using System.Windows.Media;

namespace PierwszaAplikacjaWPF
{
    class UżywanieKlawiszyDoUstawianiaWartościSuwaka : Behavior<Slider>
    {

        public Key KlawiszResetu {

            get
            {
                return (Key)GetValue(KlawiszResetProperty);
            }
            set
            {
                SetValue(KlawiszResetProperty, value);
            }

        }

        protected override void OnAttached()
        {
            base.OnAttached();
            Slider slider = this.AssociatedObject;
            slider.PreviewKeyDown += sliderPreviewKeydown;

        }

        private void sliderPreviewKeydown(object sender, KeyEventArgs e)
        {
            Slider slider = (sender as Slider);
            if (slider == null) return;
            /*
            switch (e.Key)
            {
                case Key.D0: slider.Value = 0; break;
                case Key.D1: slider.Value = 10; break;
                case Key.D2: slider.Value = 20; break;
                case Key.D3: slider.Value = 30; break;
                case Key.D4: slider.Value = 40; break;
                case Key.D5: slider.Value = 50; break;
                case Key.D6: slider.Value = 60; break;
                case Key.D7: slider.Value = 70; break;
                case Key.D8: slider.Value = 80; break;
                case Key.D9: slider.Value = 90; break;
            }
            */
            int i = (int)e.Key;
            if (i >= (int)Key.D0 && i <= (int)Key.D9)
                slider.Value = (i - (int)Key.D0) * 10;
            //if (e.Key == KlawiszResetu) slider.Value = 0;
        }

        public static readonly DependencyProperty KlawiszResetProperty = DependencyProperty.Register(
            nameof(KlawiszResetu), 
            typeof(Key), 
            typeof(UżywanieKlawiszyDoUstawianiaWartościSuwaka), 
            new PropertyMetadata(Key.None,klawiszResetuZmieniony));

        private static void klawiszResetuZmieniony(
            DependencyObject d,DependencyPropertyChangedEventArgs e)
        {
            if(d is UżywanieKlawiszyDoUstawianiaWartościSuwaka)
                
            {
                UżywanieKlawiszyDoUstawianiaWartościSuwaka z = 
                    (d as UżywanieKlawiszyDoUstawianiaWartościSuwaka);
                z.Changed += (object _sender, EventArgs _e) =>
                    {
                        if (e.NewValue != null && z.AssociatedObject != null)
                        {
                            z.AssociatedObject.PreviewKeyDown +=
                                (object __sender, KeyEventArgs __e) =>
                                {
                                    if (__e.Key == z.KlawiszResetu)
                                //z.AssociatedObject.Value = 0;
                                (__sender as Slider).Value = 0;
                                };
                        }
                    };                
            }               
        }
    }

    class SuwakZmieniającyJasnośćTła : Behavior<Control>
    {
        private static readonly DependencyProperty SuwakProperty = DependencyProperty.Register(nameof(Suwak), typeof(Slider), typeof(SuwakZmieniającyJasnośćTła), new PropertyMetadata(null, SuwakZmieniony));

        public Slider Suwak
        {
            get
            {
                return (Slider)GetValue(SuwakProperty);
            }
            set
            {
                SetValue(SuwakProperty, value);
            }
        }

        private static void SuwakZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Slider slider = e.NewValue as Slider;
            if(slider!=null)
            {
                slider.ValueChanged += (object sender, RoutedPropertyChangedEventArgs<double> _e) =>
                {
                    byte b = (byte)(slider.Value * 255 / slider.Maximum);
                    (d as SuwakZmieniającyJasnośćTła).AssociatedObject.Background =
                    new SolidColorBrush(Color.FromRgb(b, b, b));
                };
            }
        }

    }
}

