﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace KoloryWPF
{
    public class ByteToDoubleConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            byte bvalue = (byte)value;
            return (double)bvalue; //bezpieczne
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double dvalue = (double)value;
            return (byte)dvalue; //niebezpieczne
        }
    }

    public class SkładoweRGBToBrush : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            byte r = (byte)values[0];
            byte g = (byte)values[1];
            byte b = (byte)values[2];
            return new SolidColorBrush(Color.FromRgb(r, g, b));
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            SolidColorBrush brush = (SolidColorBrush)value;
            Color color = brush.Color;
            return new object[3] { color.R, color.G, color.B };
        }
    }
}
