﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace KoloryWPF.Model
{
    public static class Xml
    {
        private const string nazwaPliku = "ustawienia.xml";

        public static void Zapisz(Kolor model)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "UTF-8", "yes"),
                new XComment(DateTime.Now.ToString()),
                new XElement("kolor",
                    new XElement("R", model.R.ToString()),
                    //alt: new XElement("R", new XAttribute("Value", model.R.ToString())),
                    new XElement("G", model.G.ToString()),
                    new XElement("B", model.B.ToString())
                )
            );
            xml.Save(nazwaPliku);
        }

        public static Kolor Czytaj()
        {
            try
            {
                /*
                XDocument nbp = XDocument.Load(@"http://www.nbp.pl/kursy/xml/LastA.xml");
                string kurs = nbp.Root.Elements("pozycja").ElementAt(0).Element("kurs_sredni").Value;
                */
                XDocument xml = XDocument.Load(nazwaPliku);
                byte r = byte.Parse(xml.Root.Element("R").Value);
                byte g = byte.Parse(xml.Root.Element("G").Value);
                byte b = byte.Parse(xml.Root.Element("B").Value);
                return new Kolor() { R = r, G = g, B = b };
            }
            catch
            {
                return new Kolor();
            }
        }
    }
}
