﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using System.Windows.Media;

namespace KoloryWPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        //private Model.Kolor model = new Model.Kolor();
        private Model.Kolor model = Model.Ustawienia.Czytaj();

        #region Własność
        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R));
                onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G));
                onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B));
                onPropertyChanged(nameof(Pędzel));
            }
        }
        #endregion

        //nie-za-fajne
        public Brush Pędzel
        {
            get
            {
                return new SolidColorBrush(Color.FromRgb(R, G, B));
            }
        }

        private ICommand resetuj;

        public ICommand Resetuj
        {
            get
            {
                if (resetuj == null)
                    resetuj = new RelayCommand(
                        (object p) =>
                        {
                            R = 0;
                            B = 0;
                            G = 0;
                        },
                        (object p) =>
                        {
                            return R != 0 || G != 0 || B != 0;
                        });
                return resetuj;
            }
        }

        private ICommand zapisz;

        public ICommand Zapisz
        {
            get
            {
                if (zapisz == null)
                    zapisz = new RelayCommand(
                        (object p) =>
                        {
                            Model.Ustawienia.Zapisz(model);
                        });
                return zapisz;
            }
        }

        #region Implementacja INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        protected void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(
                    this,
                    new PropertyChangedEventArgs(nazwaWłasności));
        }
        #endregion
    }
}
