﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Interactivity;
using System.Windows.Media;

namespace KolejneZachowanie
{
    class Tekst : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            base.OnAttached();
            AssociatedObject.TextChanged += AssociatedObject_TextChanged;
        }

        private void AssociatedObject_TextChanged(object sender, TextChangedEventArgs e)
        {
            int l = AssociatedObject.Text.Length;
            if (l < 10)
                AssociatedObject.Foreground = Brushes.Yellow;
            if (l >= 10 && l < 20)
                AssociatedObject.Foreground = Brushes.Green;
            if (l >= 20)
                AssociatedObject.Foreground = Brushes.Red;
        }
    }
}
